/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.xds;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.xds.util.PilotExchanger;
import org.apache.dubbo.registry.xds.util.protocol.message.Endpoint;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.xds.EdsEndpointListener;
import org.apache.dubbo.rpc.cluster.router.xds.EdsEndpointManager;
import org.apache.dubbo.rpc.cluster.router.xds.RdsRouteRuleManager;
import org.apache.dubbo.rpc.cluster.router.xds.XdsRouteRuleListener;
import org.apache.dubbo.rpc.cluster.router.xds.rule.ClusterWeight;
import org.apache.dubbo.rpc.cluster.router.xds.rule.DestinationSubset;
import org.apache.dubbo.rpc.cluster.router.xds.rule.HTTPRouteDestination;
import org.apache.dubbo.rpc.cluster.router.xds.rule.HeaderMatcher;
import org.apache.dubbo.rpc.cluster.router.xds.rule.HttpRequestMatch;
import org.apache.dubbo.rpc.cluster.router.xds.rule.PathMatcher;
import org.apache.dubbo.rpc.cluster.router.xds.rule.XdsRouteRule;

public class XdsRouter<T>
extends AbstractStateRouter<T>
implements XdsRouteRuleListener,
EdsEndpointListener {
    private Set<String> subscribeApplications;
    private final ConcurrentHashMap<String, List<XdsRouteRule>> xdsRouteRuleMap;
    private final ConcurrentHashMap<String, DestinationSubset<T>> destinationSubsetMap;
    private final RdsRouteRuleManager rdsRouteRuleManager;
    private final EdsEndpointManager edsEndpointManager;
    private volatile BitList<Invoker<T>> currentInvokeList;
    private static final String BINARY_HEADER_SUFFIX = "-bin";
    private final boolean isEnable;

    public XdsRouter(URL url) {
        super(url);
        this.isEnable = PilotExchanger.isEnabled();
        this.rdsRouteRuleManager = url.getOrDefaultApplicationModel().getBeanFactory().getBean(RdsRouteRuleManager.class);
        this.edsEndpointManager = url.getOrDefaultApplicationModel().getBeanFactory().getBean(EdsEndpointManager.class);
        this.subscribeApplications = new ConcurrentHashSet<String>();
        this.destinationSubsetMap = new ConcurrentHashMap();
        this.xdsRouteRuleMap = new ConcurrentHashMap();
        this.currentInvokeList = new BitList(new ArrayList());
    }

    protected XdsRouter(URL url, RdsRouteRuleManager rdsRouteRuleManager, EdsEndpointManager edsEndpointManager, boolean isEnable) {
        super(url);
        this.isEnable = isEnable;
        this.rdsRouteRuleManager = rdsRouteRuleManager;
        this.edsEndpointManager = edsEndpointManager;
        this.subscribeApplications = new ConcurrentHashSet<String>();
        this.destinationSubsetMap = new ConcurrentHashMap();
        this.xdsRouteRuleMap = new ConcurrentHashMap();
        this.currentInvokeList = new BitList(new ArrayList());
    }

    @Override
    protected BitList<Invoker<T>> doRoute(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> nodeHolder, Holder<String> messageHolder) throws RpcException {
        if (!this.isEnable) {
            if (needToPrintMessage) {
                messageHolder.set("Directly Return. Reason: Pilot exchanger has not been initialized, may not in mesh mode.");
            }
            return invokers;
        }
        if (CollectionUtils.isEmpty(invokers)) {
            if (needToPrintMessage) {
                messageHolder.set("Directly Return. Reason: Invokers from previous router is empty.");
            }
            return invokers;
        }
        if (CollectionUtils.isEmptyMap(this.xdsRouteRuleMap)) {
            if (needToPrintMessage) {
                messageHolder.set("Directly Return. Reason: xds route rule is empty.");
            }
            return invokers;
        }
        StringBuilder stringBuilder = needToPrintMessage ? new StringBuilder() : null;
        String matchCluster = null;
        Set<String> appNames = this.subscribeApplications;
        for (String subscribeApplication : appNames) {
            List<XdsRouteRule> rules = this.xdsRouteRuleMap.get(subscribeApplication);
            if (CollectionUtils.isEmpty(rules)) continue;
            for (XdsRouteRule rule : rules) {
                String cluster = this.computeMatchCluster(invocation, rule);
                if (cluster == null) continue;
                matchCluster = cluster;
                break;
            }
            if (matchCluster == null) continue;
            if (stringBuilder == null) break;
            stringBuilder.append("Match App: ").append(subscribeApplication).append(" Cluster: ").append(matchCluster).append(' ');
            break;
        }
        if (matchCluster == null) {
            if (needToPrintMessage) {
                messageHolder.set("Directly Return. Reason: xds rule not match.");
            }
            return invokers;
        }
        DestinationSubset<T> destinationSubset = this.destinationSubsetMap.get(matchCluster);
        if (destinationSubset == null) {
            if (needToPrintMessage) {
                messageHolder.set(stringBuilder.append("no target subset").toString());
            }
            return BitList.emptyList();
        }
        if (needToPrintMessage) {
            messageHolder.set(stringBuilder.toString());
        }
        if (destinationSubset.getInvokers() == null) {
            return BitList.emptyList();
        }
        return destinationSubset.getInvokers().and(invokers);
    }

    private String computeMatchCluster(Invocation invocation, XdsRouteRule rule) {
        String path;
        HttpRequestMatch requestMatch = rule.getMatch();
        if (requestMatch.getPathMatcher() == null && CollectionUtils.isEmpty(requestMatch.getHeaderMatcherList())) {
            return null;
        }
        PathMatcher pathMatcher = requestMatch.getPathMatcher();
        if (pathMatcher != null && !pathMatcher.isMatch(path = "/" + invocation.getInvoker().getUrl().getPath() + "/" + invocation.getMethodName())) {
            return null;
        }
        List<HeaderMatcher> headerMatchers = requestMatch.getHeaderMatcherList();
        for (HeaderMatcher headerMatcher : headerMatchers) {
            String headerName = headerMatcher.getName();
            if (headerName.endsWith(BINARY_HEADER_SUFFIX)) {
                return null;
            }
            String headValue = invocation.getAttachment(headerName);
            if (headerMatcher.match(headValue)) continue;
            return null;
        }
        HTTPRouteDestination route = rule.getRoute();
        if (route.getCluster() != null) {
            return route.getCluster();
        }
        return this.computeWeightCluster(route.getWeightedClusters());
    }

    private String computeWeightCluster(List<ClusterWeight> weightedClusters) {
        int totalWeight = Math.max(weightedClusters.stream().mapToInt(ClusterWeight::getWeight).sum(), 1);
        int target = ThreadLocalRandom.current().nextInt(1, totalWeight + 1);
        for (ClusterWeight weightedCluster : weightedClusters) {
            int weight = weightedCluster.getWeight();
            if ((target -= weight) > 0) continue;
            return weightedCluster.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(BitList<Invoker<T>> invokers) {
        Object object;
        BitList<Object> invokerList = invokers == null ? BitList.emptyList() : invokers;
        this.currentInvokeList = invokerList.clone();
        HashSet<String> currentApplications = new HashSet<String>();
        for (Object invoker : invokerList) {
            String applicationName = invoker.getUrl().getRemoteApplication();
            if (!StringUtils.isNotEmpty(applicationName)) continue;
            currentApplications.add(applicationName);
        }
        if (!this.subscribeApplications.equals(currentApplications)) {
            object = this;
            synchronized (object) {
                for (String currentApplication : currentApplications) {
                    if (this.subscribeApplications.contains(currentApplication)) continue;
                    this.rdsRouteRuleManager.subscribeRds(currentApplication, this);
                }
                for (String preApplication : this.subscribeApplications) {
                    if (currentApplications.contains(preApplication)) continue;
                    this.rdsRouteRuleManager.unSubscribeRds(preApplication, this);
                }
                this.subscribeApplications = currentApplications;
            }
        }
        object = this;
        synchronized (object) {
            Object allInvokers = this.currentInvokeList.clone();
            for (DestinationSubset<T> subset : this.destinationSubsetMap.values()) {
                this.computeSubset(subset, (BitList<Invoker<T>>)allInvokers);
            }
        }
    }

    private void computeSubset(DestinationSubset<T> subset, BitList<Invoker<T>> invokers) {
        Set<Endpoint> endpoints = subset.getEndpoints();
        List filterInvokers = invokers.stream().filter(inv -> {
            String host = inv.getUrl().getHost();
            int port = inv.getUrl().getPort();
            Optional<Endpoint> any = endpoints.stream().filter(end -> host.equals(end.getAddress()) && port == end.getPortValue()).findAny();
            return any.isPresent();
        }).collect(Collectors.toList());
        subset.setInvokers(new BitList(filterInvokers));
    }

    @Override
    public synchronized void onRuleChange(String appName, List<XdsRouteRule> xdsRouteRules) {
        if (CollectionUtils.isEmpty(xdsRouteRules)) {
            this.clearRule(appName);
            return;
        }
        Set<String> oldCluster = this.getAllCluster();
        this.xdsRouteRuleMap.put(appName, xdsRouteRules);
        Set<String> newCluster = this.getAllCluster();
        this.changeClusterSubscribe(oldCluster, newCluster);
    }

    private Set<String> getAllCluster() {
        if (CollectionUtils.isEmptyMap(this.xdsRouteRuleMap)) {
            return new HashSet<String>();
        }
        HashSet<String> clusters = new HashSet<String>();
        this.xdsRouteRuleMap.forEach((appName, rules) -> {
            for (XdsRouteRule rule : rules) {
                HTTPRouteDestination action = rule.getRoute();
                if (action.getCluster() != null) {
                    clusters.add(action.getCluster());
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(action.getWeightedClusters())) continue;
                for (ClusterWeight weightedCluster : action.getWeightedClusters()) {
                    clusters.add(weightedCluster.getName());
                }
            }
        });
        return clusters;
    }

    private void changeClusterSubscribe(Set<String> oldCluster, Set<String> newCluster) {
        HashSet<String> removeSubscribe = new HashSet<String>(oldCluster);
        HashSet<String> addSubscribe = new HashSet<String>(newCluster);
        removeSubscribe.removeAll(newCluster);
        addSubscribe.removeAll(oldCluster);
        for (String cluster : removeSubscribe) {
            this.edsEndpointManager.unSubscribeEds(cluster, this);
            this.destinationSubsetMap.remove(cluster);
        }
        for (String cluster : addSubscribe) {
            this.destinationSubsetMap.put(cluster, new DestinationSubset(cluster));
            this.edsEndpointManager.subscribeEds(cluster, this);
        }
    }

    @Override
    public synchronized void clearRule(String appName) {
        Set<String> oldCluster = this.getAllCluster();
        List<XdsRouteRule> oldRules = this.xdsRouteRuleMap.remove(appName);
        if (CollectionUtils.isEmpty(oldRules)) {
            return;
        }
        Set<String> newCluster = this.getAllCluster();
        this.changeClusterSubscribe(oldCluster, newCluster);
    }

    @Override
    public synchronized void onEndPointChange(String cluster, Set<Endpoint> endpoints) {
        DestinationSubset<T> subset = this.destinationSubsetMap.get(cluster);
        if (subset == null) {
            return;
        }
        subset.setEndpoints(endpoints);
        this.computeSubset(subset, (BitList<Invoker<T>>)this.currentInvokeList.clone());
    }

    @Override
    public void stop() {
        for (String app : this.subscribeApplications) {
            this.rdsRouteRuleManager.unSubscribeRds(app, this);
        }
        for (String cluster : this.getAllCluster()) {
            this.edsEndpointManager.unSubscribeEds(cluster, this);
        }
    }

    @Deprecated
    Set<String> getSubscribeApplications() {
        return this.subscribeApplications;
    }

    @Deprecated
    BitList<Invoker<T>> getInvokerList() {
        return this.currentInvokeList;
    }

    @Deprecated
    ConcurrentHashMap<String, List<XdsRouteRule>> getXdsRouteRuleMap() {
        return this.xdsRouteRuleMap;
    }

    @Deprecated
    ConcurrentHashMap<String, DestinationSubset<T>> getDestinationSubsetMap() {
        return this.destinationSubsetMap;
    }
}

