/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Codec;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.transport.AbstractChannel;
import org.apache.dubbo.remoting.transport.codec.CodecAdapter;
import org.apache.dubbo.remoting.transport.netty4.Netty4BatchWriteQueue;
import org.apache.dubbo.remoting.transport.netty4.NettyBackedChannelBuffer;
import org.apache.dubbo.remoting.transport.netty4.NettyClient;
import org.apache.dubbo.remoting.utils.PayloadDropper;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

final class NettyChannel
extends AbstractChannel {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NettyChannel.class);
    private static final ConcurrentMap<io.netty.channel.Channel, NettyChannel> CHANNEL_MAP = new ConcurrentHashMap<io.netty.channel.Channel, NettyChannel>();
    private final io.netty.channel.Channel channel;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final Netty4BatchWriteQueue writeQueue;
    private final Codec2 codec;
    private final boolean encodeInIOThread;

    private NettyChannel(io.netty.channel.Channel channel, URL url, ChannelHandler handler) {
        super(url, handler);
        if (channel == null) {
            throw new IllegalArgumentException("netty channel == null;");
        }
        this.channel = channel;
        this.writeQueue = Netty4BatchWriteQueue.createWriteQueue(channel);
        this.codec = NettyChannel.getChannelCodec(url);
        this.encodeInIOThread = this.getUrl().getParameter("encode.in.io", false);
    }

    static NettyChannel getOrAddChannel(io.netty.channel.Channel ch, URL url, ChannelHandler handler) {
        if (ch == null) {
            return null;
        }
        NettyChannel ret = (NettyChannel)CHANNEL_MAP.get(ch);
        if (ret == null) {
            NettyChannel nettyChannel = new NettyChannel(ch, url, handler);
            if (ch.isActive()) {
                nettyChannel.markActive(true);
                ret = CHANNEL_MAP.putIfAbsent(ch, nettyChannel);
            }
            if (ret == null) {
                ret = nettyChannel;
            }
        } else {
            ret.markActive(true);
        }
        return ret;
    }

    static void removeChannelIfDisconnected(io.netty.channel.Channel ch) {
        NettyChannel nettyChannel;
        if (ch != null && !ch.isActive() && (nettyChannel = (NettyChannel)CHANNEL_MAP.remove(ch)) != null) {
            nettyChannel.markActive(false);
        }
    }

    static void removeChannel(io.netty.channel.Channel ch) {
        NettyChannel nettyChannel;
        if (ch != null && (nettyChannel = (NettyChannel)CHANNEL_MAP.remove(ch)) != null) {
            nettyChannel.markActive(false);
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public boolean isConnected() {
        return !this.isClosed() && this.active.get();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void markActive(boolean isActive) {
        this.active.set(isActive);
    }

    @Override
    public void send(final Object message, boolean sent) throws RemotingException {
        super.send(message, sent);
        boolean success = true;
        int timeout = 0;
        try {
            Throwable cause;
            Object outputMessage = message;
            if (!this.encodeInIOThread) {
                ByteBuf buf = this.channel.alloc().buffer();
                NettyBackedChannelBuffer buffer = new NettyBackedChannelBuffer(buf);
                this.codec.encode(this, buffer, message);
                outputMessage = buf;
            }
            ChannelFuture future = this.writeQueue.enqueue(outputMessage).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!(message instanceof Request)) {
                        return;
                    }
                    ChannelHandler handler = NettyChannel.this.getChannelHandler();
                    if (future.isSuccess()) {
                        handler.sent(NettyChannel.this, message);
                    } else {
                        Throwable t = future.cause();
                        if (t == null) {
                            return;
                        }
                        Response response = NettyChannel.buildErrorResponse((Request)message, t);
                        handler.received(NettyChannel.this, response);
                    }
                }
            });
            if (sent) {
                timeout = this.getUrl().getPositiveParameter("timeout", 1000);
                success = future.await((long)timeout);
            }
            if ((cause = future.cause()) != null) {
                throw cause;
            }
        }
        catch (Throwable e) {
            NettyChannel.removeChannelIfDisconnected(this.channel);
            throw new RemotingException(this, "Failed to send message " + PayloadDropper.getRequestWithoutData(message) + " to " + this.getRemoteAddress() + ", cause: " + e.getMessage(), e);
        }
        if (!success) {
            throw new RemotingException((Channel)this, "Failed to send message " + PayloadDropper.getRequestWithoutData(message) + " to " + this.getRemoteAddress() + "in timeout(" + timeout + "ms) limit");
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
        try {
            NettyChannel.removeChannelIfDisconnected(this.channel);
        }
        catch (Exception e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
        try {
            this.attributes.clear();
        }
        catch (Exception e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Close netty channel " + this.channel);
            }
            this.channel.close();
        }
        catch (Exception e) {
            logger.warn("6-3", "", "", e.getMessage(), e);
        }
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        return result;
    }

    @Override
    protected void setUrl(URL url) {
        super.setUrl(url);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NettyClient) {
            NettyClient client = (NettyClient)obj;
            return this.channel.equals(client.getNettyChannel());
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NettyChannel other = (NettyChannel)obj;
        return !(this.channel == null ? other.channel != null : !this.channel.equals(other.channel));
    }

    @Override
    public String toString() {
        return "NettyChannel [channel=" + this.channel + "]";
    }

    public io.netty.channel.Channel getNioChannel() {
        return this.channel;
    }

    private static Response buildErrorResponse(Request request, Throwable t) {
        Response response = new Response(request.getId(), request.getVersion());
        response.setStatus((byte)40);
        response.setErrorMessage(StringUtils.toString(t));
        return response;
    }

    private static Codec2 getChannelCodec(URL url) {
        FrameworkModel frameworkModel;
        String codecName = url.getParameter("codec");
        if (StringUtils.isEmpty(codecName)) {
            codecName = url.getProtocol();
        }
        if ((frameworkModel = ScopeModelUtil.getFrameworkModel(url.getScopeModel())).getExtensionLoader(Codec2.class).hasExtension(codecName)) {
            return frameworkModel.getExtensionLoader(Codec2.class).getExtension(codecName);
        }
        if (frameworkModel.getExtensionLoader(Codec.class).hasExtension(codecName)) {
            return new CodecAdapter(frameworkModel.getExtensionLoader(Codec.class).getExtension(codecName));
        }
        return frameworkModel.getExtensionLoader(Codec2.class).getExtension("default");
    }
}

