/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.List;
import org.apache.dubbo.common.Node;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.AddressListener;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.client.migration.InvokersChangedListener;
import org.apache.dubbo.registry.integration.InterfaceCompatibleRegistryProtocol;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.RouterFactory;
import org.apache.dubbo.rpc.cluster.SingleRouterChain;
import org.apache.dubbo.rpc.cluster.directory.AbstractDirectory;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.model.ModuleModel;

public abstract class DynamicDirectory<T>
extends AbstractDirectory<T>
implements NotifyListener {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DynamicDirectory.class);
    protected final Cluster cluster;
    protected final RouterFactory routerFactory;
    protected final String serviceKey;
    protected final Class<T> serviceType;
    protected final URL directoryUrl;
    protected final boolean multiGroup;
    protected Protocol protocol;
    protected Registry registry;
    protected volatile boolean forbidden = false;
    protected boolean shouldRegister;
    protected boolean shouldSimplified;
    protected volatile URL subscribeUrl;
    protected volatile URL registeredConsumerUrl;
    protected volatile List<Configurator> configurators;
    protected ServiceInstancesChangedListener serviceListener;
    private final boolean shouldFailFast;
    private volatile InvokersChangedListener invokersChangedListener;
    private volatile boolean invokersChanged;

    public DynamicDirectory(Class<T> serviceType, URL url) {
        super(url, true);
        ModuleModel moduleModel = url.getOrDefaultModuleModel();
        this.cluster = moduleModel.getExtensionLoader(Cluster.class).getAdaptiveExtension();
        this.routerFactory = moduleModel.getExtensionLoader(RouterFactory.class).getAdaptiveExtension();
        if (serviceType == null) {
            throw new IllegalArgumentException("service type is null.");
        }
        if (StringUtils.isEmpty(url.getServiceKey())) {
            throw new IllegalArgumentException("registry serviceKey is null.");
        }
        this.shouldRegister = !"*".equals(url.getServiceInterface()) && url.getParameter("register", true);
        this.shouldSimplified = url.getParameter("simplified", false);
        this.serviceType = serviceType;
        this.serviceKey = super.getConsumerUrl().getServiceKey();
        this.directoryUrl = this.consumerUrl;
        String group = this.directoryUrl.getGroup("");
        this.multiGroup = group != null && ("*".equals(group) || group.contains(","));
        this.shouldFailFast = Boolean.parseBoolean(ConfigurationUtils.getProperty(moduleModel, "dubbo.router.should-fail-fast", "true"));
    }

    @Override
    public void addServiceListener(ServiceInstancesChangedListener instanceListener) {
        this.serviceListener = instanceListener;
    }

    @Override
    public ServiceInstancesChangedListener getServiceListener() {
        return this.serviceListener;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public boolean isShouldRegister() {
        return this.shouldRegister;
    }

    public void subscribe(URL url) {
        this.setSubscribeUrl(url);
        this.registry.subscribe(url, this);
    }

    public void unSubscribe(URL url) {
        this.setSubscribeUrl(null);
        this.registry.unsubscribe(url, this);
    }

    @Override
    public List<Invoker<T>> doList(SingleRouterChain<T> singleRouterChain, BitList<Invoker<T>> invokers, Invocation invocation) {
        if (this.forbidden && this.shouldFailFast) {
            throw new RpcException(4, "No provider available from registry " + this.getUrl().getAddress() + " for service " + this.getConsumerUrl().getServiceKey() + " on consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", please check status of providers(disabled, not registered or in blacklist).");
        }
        if (this.multiGroup) {
            return this.getInvokers();
        }
        try {
            List<Invoker<T>> result = singleRouterChain.route(this.getConsumerUrl(), invokers, invocation);
            return result == null ? BitList.emptyList() : result;
        }
        catch (Throwable t) {
            logger.error("2-1", "", "", "Failed to execute router: " + this.getUrl() + ", cause: " + t.getMessage(), t);
            return BitList.emptyList();
        }
    }

    @Override
    public Class<T> getInterface() {
        return this.serviceType;
    }

    @Override
    public List<Invoker<T>> getAllInvokers() {
        return this.getInvokers();
    }

    @Override
    public URL getConsumerUrl() {
        return this.consumerUrl;
    }

    public URL getOriginalConsumerUrl() {
        return this.consumerUrl;
    }

    public URL getRegisteredConsumerUrl() {
        return this.registeredConsumerUrl;
    }

    public URL getSubscribeUrl() {
        return this.subscribeUrl;
    }

    public void setSubscribeUrl(URL subscribeUrl) {
        this.subscribeUrl = subscribeUrl;
    }

    public void setRegisteredConsumerUrl(URL url) {
        this.registeredConsumerUrl = !this.shouldSimplified ? url.addParameters("category", "consumers", "check", String.valueOf(false)) : URL.valueOf(url, InterfaceCompatibleRegistryProtocol.DEFAULT_REGISTER_CONSUMER_KEYS, null).addParameters("category", "consumers", "check", String.valueOf(false));
    }

    public void buildRouterChain(URL url) {
        this.setRouterChain(RouterChain.buildChain(this.getInterface(), url));
    }

    @Override
    public boolean isAvailable() {
        if (this.isDestroyed() || this.forbidden) {
            return false;
        }
        return CollectionUtils.isNotEmpty(this.getValidInvokers()) && this.getValidInvokers().stream().anyMatch(Node::isAvailable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (this.getRegisteredConsumerUrl() != null && this.registry != null && this.registry.isAvailable()) {
                this.registry.unregister(this.getRegisteredConsumerUrl());
            }
        }
        catch (Throwable t) {
            logger.warn("1-8", "", "", "unexpected error when unregister service " + this.serviceKey + " from registry: " + this.registry.getUrl(), t);
        }
        try {
            if (this.getSubscribeUrl() != null && this.registry != null && this.registry.isAvailable()) {
                this.registry.unsubscribe(this.getSubscribeUrl(), this);
            }
        }
        catch (Throwable t) {
            logger.warn("1-8", "", "", "unexpected error when unsubscribe service " + this.serviceKey + " from registry: " + this.registry.getUrl(), t);
        }
        ExtensionLoader<AddressListener> addressListenerExtensionLoader = this.getUrl().getOrDefaultModuleModel().getExtensionLoader(AddressListener.class);
        List<AddressListener> supportedListeners = addressListenerExtensionLoader.getActivateExtension(this.getUrl(), (String[])null);
        if (CollectionUtils.isNotEmpty(supportedListeners)) {
            for (AddressListener addressListener : supportedListeners) {
                addressListener.destroy(this.getConsumerUrl(), this);
            }
        }
        DynamicDirectory dynamicDirectory = this;
        synchronized (dynamicDirectory) {
            try {
                this.destroyAllInvokers();
            }
            catch (Throwable t) {
                logger.warn("1-15", "", "", "Failed to destroy service " + this.serviceKey, t);
            }
            this.routerChain.destroy();
            this.invokersChangedListener = null;
            this.serviceListener = null;
            super.destroy();
        }
    }

    @Override
    public void discordAddresses() {
        try {
            this.destroyAllInvokers();
        }
        catch (Throwable t) {
            logger.warn("1-15", "", "", "Failed to destroy service " + this.serviceKey, t);
        }
    }

    public synchronized void setInvokersChangedListener(InvokersChangedListener listener) {
        this.invokersChangedListener = listener;
        if (this.invokersChangedListener != null && this.invokersChanged) {
            this.invokersChangedListener.onChange();
        }
    }

    protected synchronized void invokersChanged() {
        this.refreshInvoker();
        this.invokersChanged = true;
        if (this.invokersChangedListener != null) {
            this.invokersChangedListener.onChange();
            this.invokersChanged = false;
        }
    }

    @Override
    public boolean isNotificationReceived() {
        return this.invokersChanged;
    }

    protected abstract void destroyAllInvokers();
}

