/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command;

import io.netty.channel.Channel;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.CommandExecutor;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.qos.command.exception.NoSuchCommandException;
import org.apache.dubbo.qos.command.exception.PermissionDenyException;
import org.apache.dubbo.qos.permission.DefaultAnonymousAccessPermissionChecker;
import org.apache.dubbo.qos.permission.PermissionChecker;
import org.apache.dubbo.qos.permission.PermissionLevel;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class DefaultCommandExecutor
implements CommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCommandExecutor.class);
    private final FrameworkModel frameworkModel;

    public DefaultCommandExecutor(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext) throws NoSuchCommandException, PermissionDenyException {
        String remoteAddress = Optional.ofNullable(commandContext.getRemote()).map(Channel::remoteAddress).map(Objects::toString).orElse("unknown");
        logger.info("[Dubbo QoS] Command Process start. Command: " + commandContext.getCommandName() + ", Args: " + Arrays.toString(commandContext.getArgs()) + ", Remote Address: " + remoteAddress);
        BaseCommand command = null;
        try {
            command = this.frameworkModel.getExtensionLoader(BaseCommand.class).getExtension(commandContext.getCommandName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (command == null) {
            logger.info("[Dubbo QoS] Command Not found. Command: " + commandContext.getCommandName() + ", Remote Address: " + remoteAddress);
            throw new NoSuchCommandException(commandContext.getCommandName());
        }
        if (commandContext.isAllowAnonymousAccess()) {
            PermissionChecker permissionChecker = DefaultAnonymousAccessPermissionChecker.INSTANCE;
            try {
                permissionChecker = this.frameworkModel.getExtensionLoader(PermissionChecker.class).getExtension("qosPermissionChecker");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Cmd cmd = command.getClass().getAnnotation(Cmd.class);
            PermissionLevel cmdRequiredPermissionLevel = cmd.requiredPermissionLevel();
            if (!permissionChecker.access(commandContext, cmdRequiredPermissionLevel)) {
                logger.info("[Dubbo QoS] Command Deny to access. Command: " + commandContext.getCommandName() + ", Args: " + Arrays.toString(commandContext.getArgs()) + ", Required Permission Level: " + (Object)((Object)cmdRequiredPermissionLevel) + ", Remote Address: " + remoteAddress);
                throw new PermissionDenyException(commandContext.getCommandName());
            }
        }
        try {
            String result = command.execute(commandContext, commandContext.getArgs());
            logger.info("[Dubbo QoS] Command Process success. Command: " + commandContext.getCommandName() + ", Args: " + Arrays.toString(commandContext.getArgs()) + ", Result: " + result + ", Remote Address: " + remoteAddress);
            return result;
        }
        catch (Throwable t) {
            logger.info("[Dubbo QoS] Command Process Failed. Command: " + commandContext.getCommandName() + ", Args: " + Arrays.toString(commandContext.getArgs()) + ", Remote Address: " + remoteAddress, t);
            throw t;
        }
    }
}

