/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.stat;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.stat.DefaultMetricsStatHandler;
import org.apache.dubbo.metrics.collector.stat.MetricsStatHandler;
import org.apache.dubbo.metrics.event.EmptyEvent;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.RTEvent;
import org.apache.dubbo.metrics.event.RequestEvent;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.rpc.Invocation;

public class MetricsStatComposite {
    public Map<MetricsEvent.Type, MetricsStatHandler> stats = new ConcurrentHashMap<MetricsEvent.Type, MetricsStatHandler>();
    private final ConcurrentMap<MethodMetric, AtomicLong> lastRT = new ConcurrentHashMap<MethodMetric, AtomicLong>();
    private final ConcurrentMap<MethodMetric, LongAccumulator> minRT = new ConcurrentHashMap<MethodMetric, LongAccumulator>();
    private final ConcurrentMap<MethodMetric, LongAccumulator> maxRT = new ConcurrentHashMap<MethodMetric, LongAccumulator>();
    private final ConcurrentMap<MethodMetric, AtomicLong> avgRT = new ConcurrentHashMap<MethodMetric, AtomicLong>();
    private final ConcurrentMap<MethodMetric, AtomicLong> totalRT = new ConcurrentHashMap<MethodMetric, AtomicLong>();
    private final ConcurrentMap<MethodMetric, AtomicLong> rtCount = new ConcurrentHashMap<MethodMetric, AtomicLong>();
    private DefaultMetricsCollector collector;

    public MetricsStatComposite(DefaultMetricsCollector collector) {
        this.collector = collector;
        this.init();
    }

    public MetricsStatHandler getHandler(MetricsEvent.Type statType) {
        return this.stats.get((Object)statType);
    }

    public Map<MethodMetric, AtomicLong> getLastRT() {
        return this.lastRT;
    }

    public Map<MethodMetric, LongAccumulator> getMinRT() {
        return this.minRT;
    }

    public Map<MethodMetric, LongAccumulator> getMaxRT() {
        return this.maxRT;
    }

    public Map<MethodMetric, AtomicLong> getAvgRT() {
        return this.avgRT;
    }

    public Map<MethodMetric, AtomicLong> getTotalRT() {
        return this.totalRT;
    }

    public Map<MethodMetric, AtomicLong> getRtCount() {
        return this.rtCount;
    }

    public MetricsEvent addRtAndRetrieveEvent(String applicationName, Invocation invocation, Long responseTime) {
        if (!this.collector.isCollectEnabled().booleanValue()) {
            return EmptyEvent.instance();
        }
        MethodMetric metric = new MethodMetric(applicationName, invocation);
        AtomicLong last = ConcurrentHashMapUtils.computeIfAbsent(this.lastRT, metric, k -> new AtomicLong());
        last.set(responseTime);
        LongAccumulator min = ConcurrentHashMapUtils.computeIfAbsent(this.minRT, metric, k -> new LongAccumulator(Long::min, Long.MAX_VALUE));
        min.accumulate(responseTime);
        LongAccumulator max = ConcurrentHashMapUtils.computeIfAbsent(this.maxRT, metric, k -> new LongAccumulator(Long::max, Long.MIN_VALUE));
        max.accumulate(responseTime);
        AtomicLong total = ConcurrentHashMapUtils.computeIfAbsent(this.totalRT, metric, k -> new AtomicLong());
        total.addAndGet(responseTime);
        AtomicLong count = ConcurrentHashMapUtils.computeIfAbsent(this.rtCount, metric, k -> new AtomicLong());
        count.incrementAndGet();
        ConcurrentHashMapUtils.computeIfAbsent(this.avgRT, metric, k -> new AtomicLong());
        return new RTEvent(metric, responseTime);
    }

    public void addApplicationInfo(String applicationName, String version) {
        MetricsStatHandler metricsStatHandler = this.stats.get((Object)MetricsEvent.Type.APPLICATION_INFO);
        metricsStatHandler.addApplication(applicationName, version);
    }

    private void init() {
        this.stats.put(MetricsEvent.Type.TOTAL, this.buildMetricsStatHandler(MetricsEvent.Type.TOTAL));
        this.stats.put(MetricsEvent.Type.SUCCEED, this.buildMetricsStatHandler(MetricsEvent.Type.SUCCEED));
        this.stats.put(MetricsEvent.Type.UNKNOWN_FAILED, this.buildMetricsStatHandler(MetricsEvent.Type.UNKNOWN_FAILED));
        this.stats.put(MetricsEvent.Type.BUSINESS_FAILED, this.buildMetricsStatHandler(MetricsEvent.Type.BUSINESS_FAILED));
        this.stats.put(MetricsEvent.Type.PROCESSING, new DefaultMetricsStatHandler());
        this.stats.put(MetricsEvent.Type.REQUEST_LIMIT, this.buildMetricsStatHandler(MetricsEvent.Type.REQUEST_LIMIT));
        this.stats.put(MetricsEvent.Type.REQUEST_TIMEOUT, this.buildMetricsStatHandler(MetricsEvent.Type.REQUEST_TIMEOUT));
        this.stats.put(MetricsEvent.Type.TOTAL_FAILED, this.buildMetricsStatHandler(MetricsEvent.Type.TOTAL_FAILED));
        this.stats.put(MetricsEvent.Type.APPLICATION_INFO, this.buildMetricsStatHandler(MetricsEvent.Type.APPLICATION_INFO));
    }

    private DefaultMetricsStatHandler buildMetricsStatHandler(final MetricsEvent.Type type) {
        return new DefaultMetricsStatHandler(){

            @Override
            public MetricsEvent retrieveMetricsEvent(MethodMetric metric) {
                return new RequestEvent(metric, type);
            }
        };
    }
}

