/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.metadata.MappingCacheManager;
import org.apache.dubbo.metadata.MappingChangedEvent;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractServiceNameMapping
implements ServiceNameMapping {
    protected final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    protected ApplicationModel applicationModel;
    private final MappingCacheManager mappingCacheManager;
    private final Map<String, Set<MappingListener>> mappingListeners = new ConcurrentHashMap<String, Set<MappingListener>>();
    private final ConcurrentMap<String, ReentrantLock> mappingLocks = new ConcurrentHashMap<String, ReentrantLock>();

    public AbstractServiceNameMapping(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        boolean enableFileCache = true;
        Optional<ApplicationConfig> application = applicationModel.getApplicationConfigManager().getApplication();
        if (application.isPresent()) {
            enableFileCache = Boolean.TRUE.equals(application.get().getEnableFileCache());
        }
        this.mappingCacheManager = new MappingCacheManager(enableFileCache, applicationModel.tryGetApplicationName(), applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class).getCacheRefreshingScheduledExecutor());
    }

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public abstract Set<String> get(URL var1);

    public abstract Set<String> getAndListen(URL var1, MappingListener var2);

    protected abstract void removeListener(URL var1, MappingListener var2);

    @Override
    public Set<String> getAndListen(URL registryURL, URL subscribedURL, MappingListener listener) {
        String key = ServiceNameMapping.buildMappingKey(subscribedURL);
        Set mappingServices = (Set)this.mappingCacheManager.get(key);
        if (CollectionUtils.isEmpty(mappingServices)) {
            String registryServices;
            try {
                this.logger.info("Local cache mapping is empty");
                mappingServices = new AsyncMappingTask(listener, subscribedURL, false).call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (CollectionUtils.isEmpty(mappingServices) && StringUtils.isNotEmpty(registryServices = registryURL.getParameter("subscribed-services"))) {
                this.logger.info(subscribedURL.getServiceInterface() + " mapping to " + registryServices + " instructed by registry subscribed-services.");
                mappingServices = AbstractServiceNameMapping.parseServices(registryServices);
            }
            if (CollectionUtils.isNotEmpty(mappingServices)) {
                this.putCachedMapping(ServiceNameMapping.buildMappingKey(subscribedURL), mappingServices);
            }
        } else {
            ExecutorService executorService = this.applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class).getMappingRefreshingExecutor();
            executorService.submit(new AsyncMappingTask(listener, subscribedURL, true));
        }
        return mappingServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MappingListener stopListen(URL subscribeURL, MappingListener listener) {
        Map<String, Set<MappingListener>> map = this.mappingListeners;
        synchronized (map) {
            String mappingKey = ServiceNameMapping.buildMappingKey(subscribeURL);
            Set<MappingListener> listeners = this.mappingListeners.get(mappingKey);
            if (CollectionUtils.isNotEmpty(listeners)) {
                listeners.remove(listener);
                listener.stop();
                this.removeListener(subscribeURL, listener);
            }
            if (CollectionUtils.isEmpty(listeners)) {
                this.mappingListeners.remove(mappingKey);
                this.removeCachedMapping(mappingKey);
                this.removeMappingLock(mappingKey);
            }
            return listener;
        }
    }

    static Set<String> parseServices(String literalServices) {
        return StringUtils.isBlank(literalServices) ? Collections.emptySet() : Collections.unmodifiableSet(new TreeSet(Stream.of(literalServices.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet())));
    }

    @Override
    public void putCachedMapping(String serviceKey, Set<String> apps) {
        this.mappingCacheManager.put(serviceKey, CollectionUtils.toTreeSet(apps));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putCachedMappingIfAbsent(String serviceKey, Set<String> apps) {
        Lock lock = this.getMappingLock(serviceKey);
        try {
            lock.lock();
            if (CollectionUtils.isEmpty((Collection)this.mappingCacheManager.get(serviceKey))) {
                this.mappingCacheManager.put(serviceKey, CollectionUtils.toTreeSet(apps));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Set<String> getMapping(URL consumerURL) {
        Set<String> mappingByUrl = ServiceNameMapping.getMappingByUrl(consumerURL);
        if (mappingByUrl != null) {
            return mappingByUrl;
        }
        return (Set)this.mappingCacheManager.get(ServiceNameMapping.buildMappingKey(consumerURL));
    }

    @Override
    public Set<String> getRemoteMapping(URL consumerURL) {
        return this.get(consumerURL);
    }

    @Override
    public Set<String> removeCachedMapping(String serviceKey) {
        return (Set)this.mappingCacheManager.remove(serviceKey);
    }

    public Lock getMappingLock(String key) {
        return this.mappingLocks.computeIfAbsent(key, _k -> new ReentrantLock());
    }

    protected void removeMappingLock(String key) {
        Lock lock = (Lock)this.mappingLocks.get(key);
        if (lock != null) {
            try {
                lock.lock();
                this.mappingLocks.remove(key);
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void $destroy() {
        this.mappingCacheManager.destroy();
        this.mappingListeners.clear();
        this.mappingLocks.clear();
    }

    private class AsyncMappingTask
    implements Callable<Set<String>> {
        private final MappingListener listener;
        private final URL subscribedURL;
        private final boolean notifyAtFirstTime;

        public AsyncMappingTask(MappingListener listener, URL subscribedURL, boolean notifyAtFirstTime) {
            this.listener = listener;
            this.subscribedURL = subscribedURL;
            this.notifyAtFirstTime = notifyAtFirstTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> call() throws Exception {
            Map map = AbstractServiceNameMapping.this.mappingListeners;
            synchronized (map) {
                Set<String> mappedServices = Collections.emptySet();
                try {
                    String mappingKey = ServiceNameMapping.buildMappingKey(this.subscribedURL);
                    if (this.listener != null) {
                        mappedServices = CollectionUtils.toTreeSet(AbstractServiceNameMapping.this.getAndListen(this.subscribedURL, this.listener));
                        Set listeners = AbstractServiceNameMapping.this.mappingListeners.computeIfAbsent(mappingKey, _k -> new HashSet());
                        listeners.add(this.listener);
                        if (CollectionUtils.isNotEmpty(mappedServices) && this.notifyAtFirstTime) {
                            this.listener.onEvent(new MappingChangedEvent(mappingKey, mappedServices));
                        }
                    } else {
                        mappedServices = AbstractServiceNameMapping.this.get(this.subscribedURL);
                        if (CollectionUtils.isNotEmpty(mappedServices)) {
                            AbstractServiceNameMapping.this.putCachedMapping(mappingKey, mappedServices);
                        }
                    }
                }
                catch (Exception e) {
                    AbstractServiceNameMapping.this.logger.error("0-25", "", "", "Failed getting mapping info from remote center. ", e);
                }
                return mappedServices;
            }
        }
    }
}

