/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.io.IOException;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.support.MultiMessage;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.dubbo.DubboCodec;

public final class DubboCountCodec
implements Codec2 {
    private DubboCodec codec;
    private FrameworkModel frameworkModel;

    public DubboCountCodec(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.codec = new DubboCodec(frameworkModel);
    }

    @Override
    public void encode(Channel channel, ChannelBuffer buffer, Object msg) throws IOException {
        if (msg instanceof MultiMessage) {
            MultiMessage multiMessage = (MultiMessage)msg;
            for (Object singleMessage : multiMessage) {
                this.codec.encode(channel, buffer, singleMessage);
            }
        } else {
            this.codec.encode(channel, buffer, msg);
        }
    }

    @Override
    public Object decode(Channel channel, ChannelBuffer buffer) throws IOException {
        int save = buffer.readerIndex();
        MultiMessage result = MultiMessage.create();
        while (true) {
            Object obj;
            if (Codec2.DecodeResult.NEED_MORE_INPUT == (obj = this.codec.decode(channel, buffer))) break;
            result.addMessage(obj);
            this.logMessageLength(obj, buffer.readerIndex() - save);
            save = buffer.readerIndex();
        }
        buffer.readerIndex(save);
        if (result.isEmpty()) {
            return Codec2.DecodeResult.NEED_MORE_INPUT;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    private void logMessageLength(Object result, int bytes) {
        if (bytes <= 0) {
            return;
        }
        if (result instanceof Request) {
            try {
                ((RpcInvocation)((Request)result).getData()).setAttachment("input", String.valueOf(bytes));
            }
            catch (Throwable throwable) {}
        } else if (result instanceof Response) {
            try {
                ((AppResponse)((Response)result).getResult()).setAttachment("output", String.valueOf(bytes));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

