/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.xds;

import io.envoyproxy.envoy.config.route.v3.VirtualHost;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.registry.xds.util.PilotExchanger;
import org.apache.dubbo.registry.xds.util.protocol.message.ListenerResult;
import org.apache.dubbo.registry.xds.util.protocol.message.RouteResult;
import org.apache.dubbo.rpc.cluster.router.xds.RdsVirtualHostListener;
import org.apache.dubbo.rpc.cluster.router.xds.XdsRouteRuleListener;
import org.apache.dubbo.rpc.cluster.router.xds.rule.XdsRouteRule;

public class RdsRouteRuleManager {
    private static final ConcurrentHashMap<String, Set<XdsRouteRuleListener>> RULE_LISTENERS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, List<XdsRouteRule>> ROUTE_DATA_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<String, RdsVirtualHostListener> RDS_LISTENERS = new ConcurrentHashMap<String, RdsVirtualHostListener>();
    private static volatile Consumer<Map<String, ListenerResult>> LDS_LISTENER;
    private static volatile Consumer<Map<String, RouteResult>> RDS_LISTENER;
    private static Map<String, RouteResult> RDS_RESULT;

    public synchronized void subscribeRds(String domain, XdsRouteRuleListener listener) {
        Set listeners = ConcurrentHashMapUtils.computeIfAbsent(RULE_LISTENERS, domain, key -> new ConcurrentHashSet());
        if (CollectionUtils.isEmpty(listeners)) {
            this.doSubscribeRds(domain);
        }
        listeners.add(listener);
        if (ROUTE_DATA_CACHE.containsKey(domain)) {
            listener.onRuleChange(domain, ROUTE_DATA_CACHE.get(domain));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSubscribeRds(String domain) {
        Class<RdsRouteRuleManager> clazz = RdsRouteRuleManager.class;
        synchronized (RdsRouteRuleManager.class) {
            if (RDS_LISTENER == null) {
                RDS_LISTENER = rds -> {
                    if (rds == null) {
                        return;
                    }
                    for (RouteResult routeResult : rds.values()) {
                        for (String domainToNotify : RDS_LISTENERS.keySet()) {
                            VirtualHost virtualHost = routeResult.searchVirtualHost(domainToNotify);
                            if (virtualHost == null) continue;
                            ((RdsVirtualHostListener)RDS_LISTENERS.get(domainToNotify)).parseVirtualHost(virtualHost);
                        }
                    }
                    RDS_RESULT = rds;
                };
            }
            if (LDS_LISTENER == null) {
                LDS_LISTENER = new Consumer<Map<String, ListenerResult>>(){
                    private volatile Set<String> configNames = null;

                    @Override
                    public void accept(Map<String, ListenerResult> listenerResults) {
                        if (listenerResults.size() == 1) {
                            for (ListenerResult listenerResult : listenerResults.values()) {
                                Set<String> newConfigNames = listenerResult.getRouteConfigNames();
                                if (this.configNames == null) {
                                    PilotExchanger.getInstance().observeRds(newConfigNames, RDS_LISTENER);
                                } else if (!this.configNames.equals(newConfigNames)) {
                                    PilotExchanger.getInstance().unObserveRds(this.configNames, RDS_LISTENER);
                                    PilotExchanger.getInstance().observeRds(newConfigNames, RDS_LISTENER);
                                }
                                this.configNames = newConfigNames;
                            }
                        }
                    }
                };
                if (PilotExchanger.isEnabled()) {
                    PilotExchanger.getInstance().observeLds(LDS_LISTENER);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ConcurrentHashMapUtils.computeIfAbsent(RDS_LISTENERS, domain, key -> new RdsVirtualHostListener(domain, this));
            RDS_LISTENER.accept(RDS_RESULT);
            return;
        }
    }

    public synchronized void unSubscribeRds(String domain, XdsRouteRuleListener listener) {
        Set<XdsRouteRuleListener> listeners = RULE_LISTENERS.get(domain);
        if (CollectionUtils.isEmpty(listeners)) {
            return;
        }
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            RULE_LISTENERS.remove(domain);
            this.doUnsubscribeRds(domain);
        }
    }

    private void doUnsubscribeRds(String domain) {
        RDS_LISTENERS.remove(domain);
    }

    public void notifyRuleChange(String domain, List<XdsRouteRule> xdsRouteRules) {
        ROUTE_DATA_CACHE.put(domain, xdsRouteRules);
        Set<XdsRouteRuleListener> listeners = RULE_LISTENERS.get(domain);
        if (CollectionUtils.isEmpty(listeners)) {
            return;
        }
        boolean empty = CollectionUtils.isEmpty(xdsRouteRules);
        for (XdsRouteRuleListener listener : listeners) {
            if (empty) {
                listener.clearRule(domain);
                continue;
            }
            listener.onRuleChange(domain, xdsRouteRules);
        }
    }

    static ConcurrentHashMap<String, Set<XdsRouteRuleListener>> getRuleListeners() {
        return RULE_LISTENERS;
    }

    static ConcurrentHashMap<String, List<XdsRouteRule>> getRouteDataCache() {
        return ROUTE_DATA_CACHE;
    }

    static Map<String, RdsVirtualHostListener> getRdsListeners() {
        return RDS_LISTENERS;
    }
}

