/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.zookeeper.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.dubbo.common.URL;

public enum CuratorFrameworkParams {
    ROOT_PATH("rootPath", "/services", value -> value),
    GROUP_PATH("group", "/services", value -> value),
    INSTANCE_HOST("instanceHost", null, value -> value),
    INSTANCE_PORT("instancePort", null, value -> value),
    BASE_SLEEP_TIME("baseSleepTimeMs", 50, Integer::valueOf),
    MAX_RETRIES("maxRetries", 10, Integer::valueOf),
    MAX_SLEEP("maxSleepMs", 500, Integer::valueOf),
    BLOCK_UNTIL_CONNECTED_WAIT("blockUntilConnectedWait", 10, Integer::valueOf),
    BLOCK_UNTIL_CONNECTED_UNIT("blockUntilConnectedUnit", TimeUnit.SECONDS, TimeUnit::valueOf);

    private final String name;
    private final Object defaultValue;
    private final Function<String, Object> converter;

    private <T> CuratorFrameworkParams(String name, T defaultValue, Function<String, T> converter) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.converter = converter;
    }

    public <T> T getParameterValue(URL url) {
        String param = url.getParameter(this.name);
        Object value = param != null ? this.converter.apply(param) : this.defaultValue;
        return (T)value;
    }
}

