/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.filter;

import java.util.function.Supplier;
import org.apache.dubbo.common.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.support.RpcUtils;

public class MetricsCollectExecutor {
    private final DefaultMetricsCollector collector;
    private final Invocation invocation;
    private String interfaceName;
    private String methodName;
    private String group;
    private String version;

    public MetricsCollectExecutor(DefaultMetricsCollector collector, Invocation invocation) {
        this.init(invocation);
        this.collector = collector;
        this.invocation = invocation;
    }

    public void beforeExecute() {
        this.collector.increaseTotalRequests(this.interfaceName, this.methodName, this.group, this.version);
        this.collector.increaseProcessingRequests(this.interfaceName, this.methodName, this.group, this.version);
        this.invocation.put("metric_filter_start_time", System.currentTimeMillis());
    }

    public void postExecute(Result result) {
        if (result.hasException()) {
            this.throwExecute(result.getException());
            return;
        }
        this.collector.increaseSucceedRequests(this.interfaceName, this.methodName, this.group, this.version);
        this.endExecute();
    }

    public void throwExecute(Throwable throwable) {
        if (throwable instanceof RpcException) {
            RpcException rpcException = (RpcException)throwable;
            switch (rpcException.getCode()) {
                case 2: {
                    this.collector.timeoutRequests(this.interfaceName, this.methodName, this.group, this.version);
                    break;
                }
                case 7: {
                    this.collector.limitRequests(this.interfaceName, this.methodName, this.group, this.version);
                    break;
                }
                case 3: {
                    this.collector.businessFailedRequests(this.interfaceName, this.methodName, this.group, this.version);
                    break;
                }
                default: {
                    this.collector.increaseUnknownFailedRequests(this.interfaceName, this.methodName, this.group, this.version);
                }
            }
        }
        this.collector.totalFailedRequests(this.interfaceName, this.methodName, this.group, this.version);
        this.endExecute(() -> throwable instanceof RpcException && ((RpcException)throwable).isBiz());
    }

    private void endExecute() {
        this.endExecute(() -> true);
    }

    private void endExecute(Supplier<Boolean> rtStat) {
        if (rtStat.get().booleanValue()) {
            Long endTime = System.currentTimeMillis();
            Long beginTime = (Long)this.invocation.get("metric_filter_start_time");
            Long rt = endTime - beginTime;
            this.collector.addRT(this.interfaceName, this.methodName, this.group, this.version, rt);
        }
        this.collector.decreaseProcessingRequests(this.interfaceName, this.methodName, this.group, this.version);
    }

    private void init(Invocation invocation) {
        String interfaceAndVersion;
        String serviceUniqueName = invocation.getTargetServiceUniqueName();
        String methodName = invocation.getMethodName();
        if (invocation instanceof RpcInvocation && RpcUtils.isGenericCall(((RpcInvocation)invocation).getParameterTypesDesc(), methodName) && invocation.getArguments() != null && invocation.getArguments().length == 3) {
            methodName = ((String)invocation.getArguments()[0]).trim();
        }
        String group = null;
        String[] arr = serviceUniqueName.split("/");
        if (arr.length == 2) {
            group = arr[0];
            interfaceAndVersion = arr[1];
        } else {
            interfaceAndVersion = arr[0];
        }
        String[] ivArr = interfaceAndVersion.split(":");
        String interfaceName = ivArr[0];
        String version = ivArr.length == 2 ? ivArr[1] : null;
        this.interfaceName = interfaceName;
        this.methodName = methodName;
        this.group = group;
        this.version = version;
    }
}

