/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest.jaxrs;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.metadata.rest.AbstractServiceRestMetadataResolver;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class JAXRSServiceRestMetadataResolver
extends AbstractServiceRestMetadataResolver {
    public JAXRSServiceRestMetadataResolver(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    @Override
    protected boolean supports0(Class<?> serviceType) {
        return AnnotationUtils.isAnnotationPresent(serviceType, "javax.ws.rs.Path");
    }

    @Override
    protected boolean isRestCapableMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        return AnnotationUtils.isAnnotationPresent((AnnotatedElement)serviceMethod, "javax.ws.rs.HttpMethod");
    }

    @Override
    protected String resolveRequestMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        Object httpMethod = AnnotationUtils.findMetaAnnotation((AnnotatedElement)serviceMethod, "javax.ws.rs.HttpMethod");
        return (String)AnnotationUtils.getValue(httpMethod);
    }

    @Override
    protected String resolveRequestPath(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        String requestBasePath = this.resolveRequestPathFromType(serviceType, serviceInterfaceClass);
        String requestRelativePath = this.resolveRequestPathFromMethod(serviceMethod);
        return PathUtils.buildPath(requestBasePath, requestRelativePath);
    }

    private String resolveRequestPathFromType(Class<?> serviceType, Class<?> serviceInterfaceClass) {
        Object path = AnnotationUtils.findAnnotation(serviceType, "javax.ws.rs.Path");
        if (path == null) {
            path = AnnotationUtils.findAnnotation(serviceInterfaceClass, "javax.ws.rs.Path");
        }
        return (String)AnnotationUtils.getValue(path);
    }

    private String resolveRequestPathFromMethod(Method serviceMethod) {
        Object path = AnnotationUtils.findAnnotation((AnnotatedElement)serviceMethod, "javax.ws.rs.Path");
        return (String)AnnotationUtils.getValue(path);
    }

    @Override
    protected void processProduces(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> produces) {
        this.addAnnotationValues(serviceMethod, "javax.ws.rs.Produces", produces);
    }

    @Override
    protected void processConsumes(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> consumes) {
        this.addAnnotationValues(serviceMethod, "javax.ws.rs.Consumes", consumes);
    }

    private void addAnnotationValues(Method serviceMethod, String annotationAttributeName, Set<String> result) {
        Object annotation = AnnotationUtils.findAnnotation((AnnotatedElement)serviceMethod, annotationAttributeName);
        String[] value = (String[])AnnotationUtils.getValue(annotation);
        if (value != null) {
            Stream.of(value).forEach(result::add);
        }
    }
}

