/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.reference.ReferenceBeanSupport;
import org.apache.dubbo.config.spring.reference.ReferenceCreator;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReferenceBeanManager
implements ApplicationContextAware {
    public static final String BEAN_NAME = "dubboReferenceBeanManager";
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private ConcurrentMap<String, List<String>> referenceKeyMap = new ConcurrentHashMap<String, List<String>>();
    private ConcurrentMap<String, String> referenceAliasMap = new ConcurrentHashMap<String, String>();
    private ConcurrentMap<String, ReferenceBean> referenceBeanMap = new ConcurrentHashMap<String, ReferenceBean>();
    private ConcurrentMap<String, ReferenceConfig> referenceConfigMap = new ConcurrentHashMap<String, ReferenceConfig>();
    private ApplicationContext applicationContext;
    private volatile boolean initialized = false;
    private ModuleModel moduleModel;

    public void addReference(ReferenceBean referenceBean) throws Exception {
        ReferenceBean oldReferenceBean;
        String referenceKey;
        String referenceBeanName = referenceBean.getId();
        Assert.notEmptyString(referenceBeanName, "The id of ReferenceBean cannot be empty");
        if (!this.initialized) {
            this.logger.warn("5-39", "", "", "Early initialize reference bean before DubboConfigBeanInitializer, the BeanPostProcessor has not been loaded at this time, which may cause abnormalities in some components (such as seata): " + referenceBeanName + " = " + ReferenceBeanSupport.generateReferenceKey(referenceBean, this.applicationContext));
        }
        if (StringUtils.isEmpty(referenceKey = this.getReferenceKeyByBeanName(referenceBeanName))) {
            referenceKey = ReferenceBeanSupport.generateReferenceKey(referenceBean, this.applicationContext);
        }
        if ((oldReferenceBean = (ReferenceBean)this.referenceBeanMap.get(referenceBeanName)) != null) {
            if (referenceBean != oldReferenceBean) {
                String oldReferenceKey = ReferenceBeanSupport.generateReferenceKey(oldReferenceBean, this.applicationContext);
                throw new IllegalStateException("Found duplicated ReferenceBean with id: " + referenceBeanName + ", old: " + oldReferenceKey + ", new: " + referenceKey);
            }
            return;
        }
        this.referenceBeanMap.put(referenceBeanName, referenceBean);
        this.registerReferenceKeyAndBeanName(referenceKey, referenceBeanName);
        if (this.initialized) {
            this.initReferenceBean(referenceBean);
        }
    }

    private String getReferenceKeyByBeanName(String referenceBeanName) {
        Set entries = this.referenceKeyMap.entrySet();
        for (Map.Entry entry : entries) {
            if (!((List)entry.getValue()).contains(referenceBeanName)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public void registerReferenceKeyAndBeanName(String referenceKey, String referenceBeanNameOrAlias) {
        List list = ConcurrentHashMapUtils.computeIfAbsent(this.referenceKeyMap, referenceKey, key -> new ArrayList());
        if (!list.contains(referenceBeanNameOrAlias)) {
            list.add(referenceBeanNameOrAlias);
            this.referenceAliasMap.put(referenceBeanNameOrAlias, (String)list.get(0));
        }
    }

    public ReferenceBean getById(String referenceBeanNameOrAlias) {
        String referenceBeanName = this.transformName(referenceBeanNameOrAlias);
        return (ReferenceBean)this.referenceBeanMap.get(referenceBeanName);
    }

    private String transformName(String referenceBeanNameOrAlias) {
        return this.referenceAliasMap.getOrDefault(referenceBeanNameOrAlias, referenceBeanNameOrAlias);
    }

    public List<String> getBeanNamesByKey(String key) {
        return Collections.unmodifiableList(this.referenceKeyMap.getOrDefault(key, Collections.EMPTY_LIST));
    }

    public Collection<ReferenceBean> getReferences() {
        return new HashSet<ReferenceBean>(this.referenceBeanMap.values());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.moduleModel = DubboBeanUtils.getModuleModel((BeanFactory)applicationContext);
    }

    public void prepareReferenceBeans() throws Exception {
        this.initialized = true;
        for (ReferenceBean referenceBean : this.getReferences()) {
            this.initReferenceBean(referenceBean);
        }
    }

    private synchronized void initReferenceBean(ReferenceBean referenceBean) throws Exception {
        ReferenceConfig referenceConfig;
        if (referenceBean.getReferenceConfig() != null) {
            return;
        }
        String referenceKey = this.getReferenceKeyByBeanName(referenceBean.getId());
        if (StringUtils.isEmpty(referenceKey)) {
            referenceKey = ReferenceBeanSupport.generateReferenceKey(referenceBean, this.applicationContext);
        }
        if ((referenceConfig = (ReferenceConfig)this.referenceConfigMap.get(referenceKey)) == null) {
            Map<String, Object> referenceAttributes = ReferenceBeanSupport.getReferenceAttributes(referenceBean);
            referenceConfig = ReferenceCreator.create(referenceAttributes, this.applicationContext).defaultInterfaceClass(referenceBean.getObjectType()).build();
            if (referenceBean.getId() != null && !referenceBean.getId().contains("#")) {
                referenceConfig.setId(referenceBean.getId());
            }
            this.referenceConfigMap.put(referenceKey, referenceConfig);
            this.moduleModel.getConfigManager().addReference(referenceConfig);
        }
        referenceBean.setKeyAndReferenceConfig(referenceKey, referenceConfig);
    }
}

