/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.command;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import org.apache.dubbo.rpc.protocol.tri.command.QueuedCommand;

public class TextDataQueueCommand
extends QueuedCommand {
    private final String data;
    private final boolean endStream;

    private TextDataQueueCommand(String text, boolean endStream) {
        this.data = text;
        this.endStream = endStream;
    }

    public static TextDataQueueCommand createCommand(String data, boolean endStream) {
        return new TextDataQueueCommand(data, endStream);
    }

    @Override
    public void doSend(ChannelHandlerContext ctx, ChannelPromise promise) {
        ByteBuf buf = ByteBufUtil.writeUtf8((ByteBufAllocator)ctx.alloc(), (CharSequence)this.data);
        ctx.write((Object)new DefaultHttp2DataFrame(buf, this.endStream), promise);
    }
}

