/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import com.google.protobuf.Any;
import com.google.rpc.DebugInfo;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Status;
import io.netty.channel.Channel;
import io.netty.handler.codec.http2.Http2Headers;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.RequestMetadata;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.call.ClientCall;
import org.apache.dubbo.rpc.protocol.tri.compressor.Compressor;
import org.apache.dubbo.rpc.protocol.tri.observer.ClientCallToObserverAdapter;
import org.apache.dubbo.rpc.protocol.tri.stream.ClientStream;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;
import org.apache.dubbo.rpc.protocol.tri.stream.TripleClientStream;
import org.apache.dubbo.rpc.protocol.tri.transport.TripleWriteQueue;

public class TripleClientCall
implements ClientCall,
ClientStream.Listener {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(TripleClientCall.class);
    private final AbstractConnectionClient connectionClient;
    private final Executor executor;
    private final FrameworkModel frameworkModel;
    private final TripleWriteQueue writeQueue;
    private RequestMetadata requestMetadata;
    private ClientStream stream;
    private ClientCall.Listener listener;
    private boolean canceled;
    private boolean headerSent;
    private boolean autoRequest = true;
    private boolean done;

    public TripleClientCall(AbstractConnectionClient connectionClient, Executor executor, FrameworkModel frameworkModel, TripleWriteQueue writeQueue) {
        this.connectionClient = connectionClient;
        this.executor = executor;
        this.frameworkModel = frameworkModel;
        this.writeQueue = writeQueue;
    }

    @Override
    public void onMessage(byte[] message) {
        if (this.done) {
            LOGGER.warn("4-15", "", "", "Received message from closed stream,connection=" + this.connectionClient + " service=" + this.requestMetadata.service + " method=" + this.requestMetadata.method.getMethodName());
            return;
        }
        try {
            Object unpacked = this.requestMetadata.packableMethod.parseResponse(message);
            this.listener.onMessage(unpacked);
        }
        catch (Throwable t) {
            this.cancelByLocal(TriRpcStatus.INTERNAL.withDescription("Deserialize response failed").withCause(t).asException());
            LOGGER.error("4-14", "", "", String.format("Failed to deserialize triple response, service=%s, method=%s,connection=%s", this.connectionClient, this.requestMetadata.service, this.requestMetadata.method.getMethodName()), t);
        }
    }

    @Override
    public void onCancelByRemote(TriRpcStatus status) {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        if (this.requestMetadata.cancellationContext != null) {
            this.requestMetadata.cancellationContext.cancel(status.asException());
        }
        this.onComplete(status, null, null);
    }

    @Override
    public void onComplete(TriRpcStatus status, Map<String, Object> attachments, Map<String, String> excludeHeaders) {
        if (this.done) {
            return;
        }
        this.done = true;
        TriRpcStatus statusFromTrailers = this.getStatusFromTrailers(excludeHeaders);
        TriRpcStatus detailStatus = statusFromTrailers != null ? statusFromTrailers : status;
        try {
            this.listener.onClose(detailStatus, StreamUtils.toAttachments(attachments));
        }
        catch (Throwable t) {
            this.cancelByLocal(TriRpcStatus.INTERNAL.withDescription("Close stream error").withCause(t).asException());
        }
        if (this.requestMetadata.cancellationContext != null) {
            this.requestMetadata.cancellationContext.cancel(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TriRpcStatus getStatusFromTrailers(Map<String, String> metadata) {
        if (null == metadata) {
            return null;
        }
        if (!metadata.containsKey(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader())) {
            return null;
        }
        String raw = metadata.remove(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader());
        byte[] statusDetailBin = StreamUtils.decodeASCIIByte(raw);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Status statusDetail = Status.parseFrom(statusDetailBin);
            List<Any> detailList = statusDetail.getDetailsList();
            Map<Class<?>, Object> classObjectMap = this.tranFromStatusDetails(detailList);
            TriRpcStatus status = TriRpcStatus.fromCode(statusDetail.getCode()).withDescription(TriRpcStatus.decodeMessage(statusDetail.getMessage()));
            DebugInfo debugInfo = (DebugInfo)classObjectMap.get(DebugInfo.class);
            if (debugInfo != null) {
                String msg = ExceptionUtils.getStackFrameString((List<String>)debugInfo.getStackEntriesList());
                status = status.appendDescription(msg);
            }
            TriRpcStatus triRpcStatus = status;
            return triRpcStatus;
        }
        catch (IOException ioException) {
            TriRpcStatus triRpcStatus = null;
            return triRpcStatus;
        }
        finally {
            ClassLoadUtil.switchContextLoader(tccl);
        }
    }

    private Map<Class<?>, Object> tranFromStatusDetails(List<Any> detailList) {
        HashMap map = new HashMap(detailList.size());
        try {
            for (Any any : detailList) {
                if (any.is(ErrorInfo.class)) {
                    ErrorInfo errorInfo = (ErrorInfo)any.unpack(ErrorInfo.class);
                    map.putIfAbsent(ErrorInfo.class, errorInfo);
                    continue;
                }
                if (!any.is(DebugInfo.class)) continue;
                DebugInfo debugInfo = (DebugInfo)any.unpack(DebugInfo.class);
                map.putIfAbsent(DebugInfo.class, debugInfo);
            }
        }
        catch (Throwable t) {
            LOGGER.error("4-14", "", "", "tran from grpc-status-details error", t);
        }
        return map;
    }

    @Override
    public void onStart() {
        this.listener.onStart(this);
    }

    @Override
    public void cancelByLocal(Throwable t) {
        if (this.canceled) {
            return;
        }
        if (!this.headerSent) {
            return;
        }
        this.canceled = true;
        if (this.stream == null) {
            return;
        }
        TriRpcStatus status = TriRpcStatus.CANCELLED.withCause(t).withDescription("Cancelled by client");
        this.stream.cancelByLocal(status);
        if (this.requestMetadata.cancellationContext != null) {
            this.requestMetadata.cancellationContext.cancel(t);
        }
    }

    @Override
    public void request(int messageNumber) {
        this.stream.request(messageNumber);
    }

    @Override
    public void sendMessage(Object message) {
        if (this.canceled) {
            throw new IllegalStateException("Call already canceled");
        }
        if (!this.headerSent) {
            this.headerSent = true;
            this.stream.sendHeader((Http2Headers)this.requestMetadata.toHeaders());
        }
        try {
            byte[] data = this.requestMetadata.packableMethod.packRequest(message);
            int compressed = "identity".equals(this.requestMetadata.compressor.getMessageEncoding()) ? 0 : 1;
            byte[] compress = this.requestMetadata.compressor.compress(data);
            this.stream.sendMessage(compress, compressed, false).addListener(f -> {
                if (!f.isSuccess()) {
                    this.cancelByLocal(f.cause());
                }
            });
        }
        catch (Throwable t) {
            LOGGER.error("4-10", "", "", String.format("Serialize triple request failed, service=%s method=%s", this.requestMetadata.service, this.requestMetadata.method), t);
            this.cancelByLocal(t);
            this.listener.onClose(TriRpcStatus.INTERNAL.withDescription("Serialize request failed").withCause(t), null);
        }
    }

    @Override
    public void halfClose() {
        if (!this.headerSent) {
            return;
        }
        if (this.canceled) {
            return;
        }
        this.stream.halfClose().addListener(f -> {
            if (!f.isSuccess()) {
                this.cancelByLocal(new IllegalStateException("Half close failed", f.cause()));
            }
        });
    }

    @Override
    public void setCompression(String compression) {
        this.requestMetadata.compressor = Compressor.getCompressor(this.frameworkModel, compression);
    }

    @Override
    public StreamObserver<Object> start(RequestMetadata metadata, ClientCall.Listener responseListener) {
        this.requestMetadata = metadata;
        this.listener = responseListener;
        this.stream = new TripleClientStream(this.frameworkModel, this.executor, (Channel)this.connectionClient.getChannel(true), (ClientStream.Listener)this, this.writeQueue);
        return new ClientCallToObserverAdapter<Object>(this);
    }

    @Override
    public boolean isAutoRequest() {
        return this.autoRequest;
    }

    @Override
    public void setAutoRequest(boolean autoRequest) {
        this.autoRequest = autoRequest;
    }
}

