/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.support.DefaultSerializationSelector;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.transport.CodecSupport;

public class UrlUtils {
    public static int getIdleTimeout(URL url) {
        int heartBeat = UrlUtils.getHeartbeat(url);
        int idleTimeout = url.getParameter("heartbeat.timeout", heartBeat * 3);
        if (idleTimeout < heartBeat * 2) {
            throw new IllegalStateException("idleTimeout < heartbeatInterval * 2");
        }
        return idleTimeout;
    }

    public static int getHeartbeat(URL url) {
        return url.getParameter("heartbeat", 60000);
    }

    public static Byte serializationId(URL url) {
        Byte serializationId;
        List<String> preferSerials = UrlUtils.preferSerialization(url);
        for (String preferSerial : preferSerials) {
            serializationId = CodecSupport.getIDByName(preferSerial);
            if (serializationId == null) continue;
            return serializationId;
        }
        serializationId = CodecSupport.getIDByName(url.getParameter("serialization"));
        if (serializationId != null) {
            return serializationId;
        }
        return CodecSupport.getIDByName(DefaultSerializationSelector.getDefaultRemotingSerialization());
    }

    public static String serializationOrDefault(URL url) {
        return UrlUtils.allSerializations(url).stream().findFirst().get();
    }

    public static Collection<String> allSerializations(URL url) {
        LinkedHashSet<String> serializations = new LinkedHashSet<String>();
        UrlUtils.preferSerialization(url).forEach(serializations::add);
        Optional.ofNullable(url.getParameter("serialization")).filter(StringUtils::isNotBlank).ifPresent(serializations::add);
        serializations.add(DefaultSerializationSelector.getDefaultRemotingSerialization());
        return Collections.unmodifiableSet(serializations);
    }

    public static List<String> preferSerialization(URL url) {
        String preferSerialization = url.getParameter("prefer_serialization");
        if (StringUtils.isNotBlank(preferSerialization)) {
            return Collections.unmodifiableList(StringUtils.splitToList(preferSerialization, ','));
        }
        return Collections.emptyList();
    }
}

