/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.dispatcher;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadlocal.InternalThreadLocal;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;

public class ChannelEventRunnable
implements Runnable {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ChannelEventRunnable.class);
    private final ChannelHandler handler;
    private final Channel channel;
    private final ChannelState state;
    private final Throwable exception;
    private final Object message;

    public ChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelState state) {
        this(channel, handler, state, null);
    }

    public ChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelState state, Object message) {
        this(channel, handler, state, message, null);
    }

    public ChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelState state, Throwable t) {
        this(channel, handler, state, null, t);
    }

    public ChannelEventRunnable(Channel channel, ChannelHandler handler, ChannelState state, Object message, Throwable exception) {
        this.channel = channel;
        this.handler = handler;
        this.state = state;
        this.message = message;
        this.exception = exception;
    }

    @Override
    public void run() {
        InternalThreadLocal.removeAll();
        if (this.state == ChannelState.RECEIVED) {
            try {
                this.handler.received(this.channel, this.message);
            }
            catch (Exception e) {
                logger.warn("6-4", "", "", "ChannelEventRunnable handle " + (Object)((Object)this.state) + " operation error, channel is " + this.channel + ", message is " + this.message, e);
            }
        } else {
            switch (this.state) {
                case CONNECTED: {
                    try {
                        this.handler.connected(this.channel);
                    }
                    catch (Exception e) {
                        logger.warn("6-4", "", "", "ChannelEventRunnable handle " + (Object)((Object)this.state) + " operation error, channel is " + this.channel, e);
                    }
                    break;
                }
                case DISCONNECTED: {
                    try {
                        this.handler.disconnected(this.channel);
                    }
                    catch (Exception e) {
                        logger.warn("6-4", "", "", "ChannelEventRunnable handle " + (Object)((Object)this.state) + " operation error, channel is " + this.channel, e);
                    }
                    break;
                }
                case SENT: {
                    try {
                        this.handler.sent(this.channel, this.message);
                    }
                    catch (Exception e) {
                        logger.warn("6-4", "", "", "ChannelEventRunnable handle " + (Object)((Object)this.state) + " operation error, channel is " + this.channel + ", message is " + this.message, e);
                    }
                    break;
                }
                case CAUGHT: {
                    try {
                        this.handler.caught(this.channel, this.exception);
                    }
                    catch (Exception e) {
                        logger.warn("6-4", "", "", "ChannelEventRunnable handle " + (Object)((Object)this.state) + " operation error, channel is " + this.channel + ", message is: " + this.message + ", exception is " + this.exception, e);
                    }
                    break;
                }
                default: {
                    logger.warn("6-4", "", "", "unknown state: " + (Object)((Object)this.state) + ", message is " + this.message);
                }
            }
        }
        InternalThreadLocal.removeAll();
    }

    public static enum ChannelState {
        CONNECTED,
        DISCONNECTED,
        SENT,
        RECEIVED,
        CAUGHT;

    }
}

