/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.util.protocol.impl;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.config.route.v3.Route;
import io.envoyproxy.envoy.config.route.v3.RouteAction;
import io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.xds.util.XdsChannel;
import org.apache.dubbo.registry.xds.util.protocol.AbstractProtocol;
import org.apache.dubbo.registry.xds.util.protocol.delta.DeltaRoute;
import org.apache.dubbo.registry.xds.util.protocol.message.RouteResult;

public class RdsProtocol
extends AbstractProtocol<RouteResult, DeltaRoute> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(RdsProtocol.class);

    public RdsProtocol(XdsChannel xdsChannel, Node node, int pollingPoolSize, int pollingTimeout) {
        super(xdsChannel, node, pollingPoolSize, pollingTimeout);
    }

    @Override
    public String getTypeUrl() {
        return "type.googleapis.com/envoy.config.route.v3.RouteConfiguration";
    }

    @Override
    protected RouteResult decodeDiscoveryResponse(DiscoveryResponse response) {
        if (this.getTypeUrl().equals(response.getTypeUrl())) {
            Map map = response.getResourcesList().stream().map(RdsProtocol::unpackRouteConfiguration).filter(Objects::nonNull).map(RdsProtocol::decodeResourceToListener).reduce((a, b) -> {
                a.putAll(b);
                return a;
            }).orElse(new HashMap());
            return new RouteResult(map);
        }
        return new RouteResult();
    }

    private static Map<String, Set<String>> decodeResourceToListener(RouteConfiguration resource) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        resource.getVirtualHostsList().forEach(virtualHost -> {
            Set cluster = virtualHost.getRoutesList().stream().map(Route::getRoute).map(RouteAction::getCluster).collect(Collectors.toSet());
            for (String domain : virtualHost.getDomainsList()) {
                map.put(domain, cluster);
            }
        });
        return map;
    }

    private static RouteConfiguration unpackRouteConfiguration(Any any) {
        try {
            return (RouteConfiguration)any.unpack(RouteConfiguration.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("1-31", "", "", "Error occur when decode xDS response.", e);
            return null;
        }
    }
}

