/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.nacos.NacosConnectionManager;

public class NacosNamingServiceWrapper {
    private static final String INNERCLASS_SYMBOL = "$";
    private static final String INNERCLASS_COMPATIBLE_SYMBOL = "___";
    private final NacosConnectionManager nacosConnectionManager;
    private final boolean isSupportBatchRegister;
    private final Map<InstanceId, InstancesInfo> registerStatus = new ConcurrentHashMap<InstanceId, InstancesInfo>();
    private final Map<SubscribeInfo, NamingService> subscribeStatus = new ConcurrentHashMap<SubscribeInfo, NamingService>();
    private final Lock mapLock = new ReentrantLock();

    public NacosNamingServiceWrapper(NacosConnectionManager nacosConnectionManager) {
        this.nacosConnectionManager = nacosConnectionManager;
        this.isSupportBatchRegister = MethodUtils.findMethod(NamingService.class, "batchRegisterInstance", String.class, String.class, List.class) != null;
    }

    @Deprecated
    protected NacosNamingServiceWrapper(NacosConnectionManager nacosConnectionManager, boolean isSupportBatchRegister) {
        this.nacosConnectionManager = nacosConnectionManager;
        this.isSupportBatchRegister = isSupportBatchRegister;
    }

    public String getServerStatus() {
        return this.nacosConnectionManager.getNamingService().getServerStatus();
    }

    public void subscribe(String serviceName, String group, EventListener eventListener) throws NacosException {
        String nacosServiceName = this.handleInnerSymbol(serviceName);
        SubscribeInfo subscribeInfo = new SubscribeInfo(nacosServiceName, group, eventListener);
        NamingService namingService = this.subscribeStatus.computeIfAbsent(subscribeInfo, info -> this.nacosConnectionManager.getNamingService());
        namingService.subscribe(nacosServiceName, group, eventListener);
    }

    public void unsubscribe(String serviceName, String group, EventListener eventListener) throws NacosException {
        String nacosServiceName = this.handleInnerSymbol(serviceName);
        SubscribeInfo subscribeInfo = new SubscribeInfo(nacosServiceName, group, eventListener);
        NamingService namingService = this.subscribeStatus.get(subscribeInfo);
        if (namingService != null) {
            namingService.unsubscribe(nacosServiceName, group, eventListener);
            this.subscribeStatus.remove(subscribeInfo);
        }
    }

    public List<Instance> getAllInstances(String serviceName, String group) throws NacosException {
        return this.nacosConnectionManager.getNamingService().getAllInstances(this.handleInnerSymbol(serviceName), group);
    }

    /*
     * Exception decompiling
     */
    public void registerInstance(String serviceName, String group, Instance instance) throws NacosException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterInstance(String serviceName, String group, String ip, int port) throws NacosException {
        InstancesInfo instancesInfo;
        String nacosServiceName = this.handleInnerSymbol(serviceName);
        try {
            this.mapLock.lock();
            instancesInfo = this.registerStatus.computeIfAbsent(new InstanceId(nacosServiceName, group), id -> new InstancesInfo());
        }
        finally {
            this.mapLock.unlock();
        }
        try {
            instancesInfo.lock();
            List instances = instancesInfo.getInstances().stream().map(InstanceInfo::getInstance).filter(instance -> Objects.equals(instance.getIp(), ip) && instance.getPort() == port).collect(Collectors.toList());
            for (Instance instance2 : instances) {
                this.deregisterInstance(serviceName, group, instance2);
            }
        }
        finally {
            instancesInfo.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterInstance(String serviceName, String group, Instance instance) throws NacosException {
        InstancesInfo instancesInfo;
        String nacosServiceName = this.handleInnerSymbol(serviceName);
        try {
            this.mapLock.lock();
            instancesInfo = this.registerStatus.computeIfAbsent(new InstanceId(nacosServiceName, group), id -> new InstancesInfo());
        }
        finally {
            this.mapLock.unlock();
        }
        try {
            instancesInfo.lock();
            Optional<InstanceInfo> optional = instancesInfo.getInstances().stream().filter(instanceInfo -> instanceInfo.getInstance().equals((Object)instance)).findAny();
            if (!optional.isPresent()) {
                return;
            }
            InstanceInfo instanceInfo2 = optional.get();
            instancesInfo.getInstances().remove(instanceInfo2);
            try {
                this.mapLock.lock();
                if (instancesInfo.getInstances().isEmpty()) {
                    this.registerStatus.remove(new InstanceId(nacosServiceName, group));
                    instancesInfo.setValid(false);
                }
            }
            finally {
                this.mapLock.unlock();
            }
            if (instancesInfo.getInstances().isEmpty()) {
                instanceInfo2.getNamingService().deregisterInstance(nacosServiceName, group, instance);
                instancesInfo.setBatchRegistered(false);
                return;
            }
            if (instancesInfo.isBatchRegistered()) {
                ArrayList<Instance> instanceListToRegister = new ArrayList<Instance>();
                for (InstanceInfo info : instancesInfo.getInstances()) {
                    instanceListToRegister.add(info.getInstance());
                }
                instanceInfo2.getNamingService().batchRegisterInstance(nacosServiceName, group, instanceListToRegister);
            } else {
                instanceInfo2.getNamingService().deregisterInstance(nacosServiceName, group, instance);
            }
        }
        finally {
            instancesInfo.unlock();
        }
    }

    public ListView<String> getServicesOfServer(int pageNo, int pageSize, String group) throws NacosException {
        return this.nacosConnectionManager.getNamingService().getServicesOfServer(pageNo, pageSize, group);
    }

    public List<Instance> selectInstances(String serviceName, String group, boolean healthy) throws NacosException {
        return this.nacosConnectionManager.getNamingService().selectInstances(this.handleInnerSymbol(serviceName), group, healthy);
    }

    public void shutdown() throws NacosException {
        this.nacosConnectionManager.shutdownAll();
    }

    private String handleInnerSymbol(String serviceName) {
        if (StringUtils.isEmpty(serviceName)) {
            return null;
        }
        return serviceName.replace(INNERCLASS_SYMBOL, INNERCLASS_COMPATIBLE_SYMBOL);
    }

    @Deprecated
    protected Map<InstanceId, InstancesInfo> getRegisterStatus() {
        return this.registerStatus;
    }

    private static /* synthetic */ InstancesInfo lambda$registerInstance$1(InstanceId id) {
        return new InstancesInfo();
    }

    private static class SubscribeInfo {
        private final String serviceName;
        private final String group;
        private final EventListener eventListener;

        public SubscribeInfo(String serviceName, String group, EventListener eventListener) {
            this.serviceName = serviceName;
            this.group = group;
            this.eventListener = eventListener;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscribeInfo that = (SubscribeInfo)o;
            return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.group, that.group) && Objects.equals(this.eventListener, that.eventListener);
        }

        public int hashCode() {
            return Objects.hash(this.serviceName, this.group, this.eventListener);
        }
    }

    protected static class InstanceInfo {
        private final Instance instance;
        private final NamingService namingService;

        public InstanceInfo(Instance instance, NamingService namingService) {
            this.instance = instance;
            this.namingService = namingService;
        }

        public Instance getInstance() {
            return this.instance;
        }

        public NamingService getNamingService() {
            return this.namingService;
        }
    }

    protected static class InstancesInfo {
        private final Lock lock = new ReentrantLock();
        private final List<InstanceInfo> instances = new ArrayList<InstanceInfo>();
        private volatile boolean batchRegistered = false;
        private volatile boolean valid = true;

        protected InstancesInfo() {
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public List<InstanceInfo> getInstances() {
            return this.instances;
        }

        public boolean isBatchRegistered() {
            return this.batchRegistered;
        }

        public void setBatchRegistered(boolean batchRegistered) {
            this.batchRegistered = batchRegistered;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }
    }

    protected static class InstanceId {
        private final String serviceName;
        private final String group;

        public InstanceId(String serviceName, String group) {
            this.serviceName = serviceName;
            this.group = group;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getGroup() {
            return this.group;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstanceId that = (InstanceId)o;
            return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.group, that.group);
        }

        public int hashCode() {
            return Objects.hash(this.serviceName, this.group);
        }
    }
}

