/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.aggregate;

import com.tdunning.math.stats.TDigest;
import java.util.concurrent.TimeUnit;

public class TimeWindowQuantile {
    private final double compression;
    private final TDigest[] ringBuffer;
    private int currentBucket;
    private long lastRotateTimestampMillis;
    private final long durationBetweenRotatesMillis;

    public TimeWindowQuantile(double compression, int bucketNum, int timeWindowSeconds) {
        this.compression = compression;
        this.ringBuffer = new TDigest[bucketNum];
        for (int i = 0; i < bucketNum; ++i) {
            this.ringBuffer[i] = TDigest.createDigest((double)compression);
        }
        this.currentBucket = 0;
        this.lastRotateTimestampMillis = System.currentTimeMillis();
        this.durationBetweenRotatesMillis = TimeUnit.SECONDS.toMillis(timeWindowSeconds) / (long)bucketNum;
    }

    public synchronized double quantile(double q) {
        TDigest currentBucket = this.rotate();
        return currentBucket.quantile(q);
    }

    public synchronized void add(double value) {
        this.rotate();
        for (TDigest bucket : this.ringBuffer) {
            bucket.add(value);
        }
    }

    private TDigest rotate() {
        long timeSinceLastRotateMillis = System.currentTimeMillis() - this.lastRotateTimestampMillis;
        while (timeSinceLastRotateMillis > this.durationBetweenRotatesMillis) {
            this.ringBuffer[this.currentBucket] = TDigest.createDigest((double)this.compression);
            if (++this.currentBucket >= this.ringBuffer.length) {
                this.currentBucket = 0;
            }
            timeSinceLastRotateMillis -= this.durationBetweenRotatesMillis;
            this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
        }
        return this.ringBuffer[this.currentBucket];
    }
}

