/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.common.utils.IOUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;
import org.apache.dubbo.metadata.rest.ServiceRestMetadataReader;

public class ClassPathServiceRestMetadataReader
implements ServiceRestMetadataReader {
    private final String serviceRestMetadataJsonResourcePath;

    public ClassPathServiceRestMetadataReader() {
        this("META-INF/dubbo/service-rest-metadata.json");
    }

    public ClassPathServiceRestMetadataReader(String serviceRestMetadataJsonResourcePath) {
        this.serviceRestMetadataJsonResourcePath = serviceRestMetadataJsonResourcePath;
    }

    @Override
    public List<ServiceRestMetadata> read() {
        LinkedList serviceRestMetadataList = new LinkedList();
        ClassLoader classLoader = this.getClass().getClassLoader();
        ThrowableAction.execute(() -> {
            Enumeration<URL> resources = classLoader.getResources(this.serviceRestMetadataJsonResourcePath);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                InputStream inputStream = resource.openStream();
                String json = IOUtils.read(inputStream, "UTF-8");
                serviceRestMetadataList.addAll(JsonUtils.getJson().toJavaList(json, ServiceRestMetadata.class));
            }
        });
        return Collections.unmodifiableList(serviceRestMetadataList);
    }
}

