/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.deploy;

import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.metrics.service.MetricsService;
import org.apache.dubbo.common.metrics.service.MetricsServiceExporter;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.bootstrap.builders.InternalServiceConfigBuilder;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public class DefaultMetricsServiceExporter
implements MetricsServiceExporter,
ScopeModelAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ApplicationModel applicationModel;
    private MetricsService metricsService;
    private volatile ServiceConfig<MetricsService> serviceConfig;

    @Override
    public void init() {
        this.initialize();
    }

    private void initialize() {
        MetricsConfig metricsConfig = this.applicationModel.getApplicationConfigManager().getMetrics().orElse(null);
        if (metricsConfig != null && this.metricsService == null) {
            if ("prometheus".equals(metricsConfig.getProtocol())) {
                this.metricsService = this.applicationModel.getExtensionLoader(MetricsService.class).getDefaultExtension();
            } else {
                this.logger.warn("Protocol " + metricsConfig.getProtocol() + " not support for new metrics mechanism. Using old metrics mechanism instead.");
            }
        }
    }

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    @Override
    public MetricsServiceExporter export() {
        if (this.metricsService != null) {
            if (!this.isExported()) {
                ServiceConfig<MetricsService> serviceConfig = InternalServiceConfigBuilder.newBuilder(this.applicationModel).interfaceClass(MetricsService.class).protocol(this.getMetricsConfig().getExportServiceProtocol()).port(this.getMetricsConfig().getExportServicePort()).ref(this.metricsService).registryId("internal-metrics-registry").build();
                serviceConfig.export();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("The MetricsService exports urls : " + serviceConfig.getExportedUrls());
                }
                this.serviceConfig = serviceConfig;
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("The MetricsService has been exported : " + this.serviceConfig.getExportedUrls());
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("The MetricsConfig not exist, will not export metrics service.");
        }
        return this;
    }

    @Override
    public MetricsServiceExporter unexport() {
        if (this.isExported()) {
            this.serviceConfig.unexport();
        }
        return this;
    }

    private MetricsConfig getMetricsConfig() {
        return this.applicationModel.getApplicationConfigManager().getMetrics().get();
    }

    private boolean isExported() {
        return this.serviceConfig != null && this.serviceConfig.isExported() && !this.serviceConfig.isUnexported();
    }
}

