/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2.dubbo;

import com.alibaba.com.caucho.hessian.io.SerializerFactory;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

@SPI(value="default", scope=ExtensionScope.FRAMEWORK)
public interface Hessian2FactoryInitializer {
    public static final String ALLOW = System.getProperty("dubbo.application.hessian2.allow");
    public static final String DENY = System.getProperty("dubbo.application.hessian2.deny");
    public static final String WHITELIST = System.getProperty("dubbo.application.hessian2.whitelist");
    public static final String ALLOW_NON_SERIALIZABLE = System.getProperty("dubbo.hessian.allowNonSerializable", "false");

    public SerializerFactory getSerializerFactory();

    public static Hessian2FactoryInitializer getInstance() {
        ExtensionLoader<Hessian2FactoryInitializer> loader = FrameworkModel.defaultModel().getExtensionLoader(Hessian2FactoryInitializer.class);
        if (StringUtils.isNotEmpty(WHITELIST)) {
            return loader.getExtension("whitelist");
        }
        return loader.getDefaultExtension();
    }
}

