/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;
import org.apache.dubbo.rpc.protocol.tri.stream.TripleServerStream;

public class TripleHttp2FrameServerHandler
extends ChannelDuplexHandler {
    private static final AttributeKey<TripleServerStream> SERVER_STREAM_KEY = AttributeKey.valueOf((String)"tri_server_stream");
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(TripleHttp2FrameServerHandler.class);
    private final PathResolver pathResolver;
    private final FrameworkModel frameworkModel;
    private final Executor executor;
    private final List<HeaderFilter> filters;
    private final String acceptEncoding;

    public TripleHttp2FrameServerHandler(FrameworkModel frameworkModel, Executor executor, List<HeaderFilter> filters) {
        this.frameworkModel = frameworkModel;
        this.executor = executor;
        this.filters = filters;
        this.acceptEncoding = String.join((CharSequence)",", frameworkModel.getExtensionLoader(DeCompressor.class).getSupportedExtensions());
        this.pathResolver = frameworkModel.getExtensionLoader(PathResolver.class).getDefaultExtension();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            this.onHeadersRead(ctx, (Http2HeadersFrame)msg);
        } else if (msg instanceof Http2DataFrame) {
            this.onDataRead(ctx, (Http2DataFrame)msg);
        } else if (msg instanceof ReferenceCounted) {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof Http2ResetFrame) {
            this.onResetRead(ctx, (Http2ResetFrame)evt);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void onResetRead(ChannelHandlerContext ctx, Http2ResetFrame frame) {
        TripleServerStream tripleServerStream = (TripleServerStream)ctx.channel().attr(SERVER_STREAM_KEY).get();
        LOGGER.warn("4-14", "", "", "Triple Server received remote reset errorCode=" + frame.errorCode());
        if (tripleServerStream != null) {
            tripleServerStream.transportObserver.cancelByRemote(frame.errorCode());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("4-14", "", "", "Exception in processing triple message", cause);
        }
        TriRpcStatus status = TriRpcStatus.getStatus(cause, "Provider's error:\n" + cause.getMessage());
        TripleServerStream tripleServerStream = (TripleServerStream)ctx.channel().attr(SERVER_STREAM_KEY).get();
        if (tripleServerStream != null) {
            tripleServerStream.cancelByLocal(status);
        }
    }

    public void onDataRead(ChannelHandlerContext ctx, Http2DataFrame msg) throws Exception {
        TripleServerStream tripleServerStream = (TripleServerStream)ctx.channel().attr(SERVER_STREAM_KEY).get();
        tripleServerStream.transportObserver.onData(msg.content(), msg.isEndStream());
    }

    public void onHeadersRead(ChannelHandlerContext ctx, Http2HeadersFrame msg) throws Exception {
        TripleServerStream tripleServerStream = new TripleServerStream(ctx.channel(), this.frameworkModel, this.executor, this.pathResolver, this.acceptEncoding, this.filters);
        ctx.channel().attr(SERVER_STREAM_KEY).set((Object)tripleServerStream);
        tripleServerStream.transportObserver.onHeader(msg.headers(), msg.isEndStream());
    }
}

