/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.grpc.health.v1.HealthCheckResponse;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.remoting.api.ConnectionManager;
import org.apache.dubbo.remoting.api.pu.DefaultPuHandler;
import org.apache.dubbo.remoting.exchange.PortUnificationExchanger;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.AbstractExporter;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.tri.TripleInvoker;
import org.apache.dubbo.rpc.protocol.tri.compressor.DeCompressor;
import org.apache.dubbo.rpc.protocol.tri.service.TriBuiltinService;

public class TripleProtocol
extends AbstractProtocol {
    public static final String METHOD_ATTR_PACK = "pack";
    private static final Logger logger = LoggerFactory.getLogger(TripleProtocol.class);
    private final PathResolver pathResolver;
    private final TriBuiltinService triBuiltinService;
    private final ConnectionManager connectionManager;
    private final String acceptEncodings;
    public static boolean CONVERT_NO_LOWER_HEADER = false;

    public TripleProtocol(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.triBuiltinService = new TriBuiltinService(frameworkModel);
        this.pathResolver = frameworkModel.getExtensionLoader(PathResolver.class).getDefaultExtension();
        CONVERT_NO_LOWER_HEADER = ConfigurationUtils.getEnvConfiguration(ApplicationModel.defaultModel()).getBoolean("dubbo.rpc.tri.support-no-lower-header", true);
        Set<String> supported = frameworkModel.getExtensionLoader(DeCompressor.class).getSupportedExtensions();
        this.acceptEncodings = String.join((CharSequence)",", supported);
        this.connectionManager = frameworkModel.getExtensionLoader(ConnectionManager.class).getExtension("multiple");
    }

    @Override
    public int getDefaultPort() {
        return 50051;
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        final URL url = invoker.getUrl();
        final String key = TripleProtocol.serviceKey(url);
        AbstractExporter exporter = new AbstractExporter<T>(invoker){

            @Override
            public void afterUnExport() {
                TripleProtocol.this.pathResolver.remove(url.getServiceKey());
                TripleProtocol.this.pathResolver.remove(url.getServiceModel().getServiceModel().getInterfaceName());
                if (TripleProtocol.this.triBuiltinService.enable()) {
                    TripleProtocol.this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceKey(), HealthCheckResponse.ServingStatus.NOT_SERVING);
                    TripleProtocol.this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceInterface(), HealthCheckResponse.ServingStatus.NOT_SERVING);
                }
                TripleProtocol.this.exporterMap.remove(key);
            }
        };
        this.exporterMap.put(key, exporter);
        this.invokers.add(invoker);
        this.pathResolver.add(url.getServiceKey(), invoker);
        this.pathResolver.add(url.getServiceModel().getServiceModel().getInterfaceName(), invoker);
        if (this.triBuiltinService.enable()) {
            this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceKey(), HealthCheckResponse.ServingStatus.SERVING);
            this.triBuiltinService.getHealthStatusManager().setStatus(url.getServiceInterface(), HealthCheckResponse.ServingStatus.SERVING);
        }
        url.getOrDefaultApplicationModel().getExtensionLoader(ExecutorRepository.class).getDefaultExtension().createExecutorIfAbsent(url);
        PortUnificationExchanger.bind(url, new DefaultPuHandler());
        this.optimizeSerialization(url);
        return exporter;
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        this.optimizeSerialization(url);
        ExecutorService streamExecutor = this.getOrCreateStreamExecutor(url.getOrDefaultApplicationModel(), url);
        TripleInvoker<T> invoker = new TripleInvoker<T>(type, url, this.acceptEncodings, this.connectionManager, this.invokers, streamExecutor);
        this.invokers.add(invoker);
        return invoker;
    }

    private ExecutorService getOrCreateStreamExecutor(ApplicationModel applicationModel, URL url) {
        ExecutorService executor = applicationModel.getExtensionLoader(ExecutorRepository.class).getDefaultExtension().createExecutorIfAbsent(url);
        Objects.requireNonNull(executor, String.format("No available executor found in %s", url));
        return executor;
    }

    @Override
    protected <T> Invoker<T> protocolBindingRefer(Class<T> type, URL url) throws RpcException {
        return null;
    }

    @Override
    public void destroy() {
        if (logger.isInfoEnabled()) {
            logger.info("Destroying protocol [" + this.getClass().getSimpleName() + "] ...");
        }
        PortUnificationExchanger.close();
        this.pathResolver.destroy();
        super.destroy();
    }
}

