/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.utils.ConcurrentHashSet;

public class RouterSnapshotSwitcher {
    private volatile boolean enable;
    private final Set<String> enabledService = new ConcurrentHashSet<String>();
    private static final int MAX_LENGTH = 32;
    private final AtomicInteger offset = new AtomicInteger(0);
    private volatile String[] recentSnapshot = new String[32];

    public boolean isEnable() {
        return this.enable;
    }

    public synchronized void addEnabledService(String service) {
        this.enabledService.add(service);
        this.enable = true;
        this.recentSnapshot = new String[32];
    }

    public boolean isEnable(String service) {
        return this.enabledService.contains(service);
    }

    public synchronized void removeEnabledService(String service) {
        this.enabledService.remove(service);
        this.enable = this.enabledService.size() > 0;
        this.recentSnapshot = new String[32];
    }

    public synchronized Set<String> getEnabledService() {
        return Collections.unmodifiableSet(this.enabledService);
    }

    public void setSnapshot(String snapshot) {
        if (this.enable) {
            this.recentSnapshot[this.offset.getAndIncrement() % 32] = System.currentTimeMillis() + " - " + snapshot;
        }
    }

    public String[] cloneSnapshot() {
        String[] clonedSnapshot = new String[32];
        for (int i = 0; i < 32; ++i) {
            clonedSnapshot[i] = this.recentSnapshot[i];
        }
        return clonedSnapshot;
    }
}

