/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos.util;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.PropertyKeyConst;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import java.util.Map;
import java.util.Properties;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringConstantFieldValuePredicate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.nacos.NacosNamingServiceWrapper;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class NacosNamingServiceUtils {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NacosNamingServiceUtils.class);
    private static final String NACOS_GROUP_KEY = "nacos.group";
    private static final String NACOS_RETRY_KEY = "nacos.retry";
    private static final String NACOS_CHECK_KEY = "nacos.check";
    private static final String NACOS_RETRY_WAIT_KEY = "nacos.retry-wait";

    public static Instance toInstance(ServiceInstance serviceInstance) {
        Instance instance = new Instance();
        instance.setServiceName(serviceInstance.getServiceName());
        instance.setIp(serviceInstance.getHost());
        instance.setPort(serviceInstance.getPort());
        instance.setMetadata(serviceInstance.getSortedMetadata());
        instance.setEnabled(serviceInstance.isEnabled());
        instance.setHealthy(serviceInstance.isHealthy());
        return instance;
    }

    public static ServiceInstance toServiceInstance(URL registryUrl, Instance instance) {
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance(NamingUtils.getServiceName((String)instance.getServiceName()), instance.getIp(), instance.getPort(), ScopeModelUtil.getApplicationModel(registryUrl.getScopeModel()));
        serviceInstance.setMetadata(instance.getMetadata());
        serviceInstance.setEnabled(instance.isEnabled());
        serviceInstance.setHealthy(instance.isHealthy());
        return serviceInstance;
    }

    public static String getGroup(URL connectionURL) {
        String group = connectionURL.getParameter("group", "DEFAULT_GROUP");
        return connectionURL.getParameter(NACOS_GROUP_KEY, group);
    }

    public static NacosNamingServiceWrapper createNamingService(URL connectionURL) {
        Properties nacosProperties = NacosNamingServiceUtils.buildNacosProperties(connectionURL);
        int retryTimes = connectionURL.getPositiveParameter(NACOS_RETRY_KEY, 10);
        int sleepMsBetweenRetries = connectionURL.getPositiveParameter(NACOS_RETRY_WAIT_KEY, 1000);
        boolean check = connectionURL.getParameter(NACOS_CHECK_KEY, true);
        NamingService namingService = null;
        try {
            for (int i = 0; i < retryTimes + 1; ++i) {
                namingService = NacosFactory.createNamingService((Properties)nacosProperties);
                if (!(!check || "UP".equals(namingService.getServerStatus()) && NacosNamingServiceUtils.testNamingService(namingService))) {
                    logger.warn("1-37", "", "", "Failed to connect to nacos naming server. " + (i < retryTimes ? "Dubbo will try to retry in " + sleepMsBetweenRetries + ". " : "Exceed retry max times.") + "Try times: " + (i + 1));
                    namingService.shutDown();
                    namingService = null;
                    Thread.sleep(sleepMsBetweenRetries);
                    continue;
                }
                break;
            }
        }
        catch (NacosException e) {
            logger.error("1-37", "", "", e.getErrMsg(), e);
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            logger.error("99-1", "", "", "Interrupted when creating nacos naming service client.", e);
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        if (namingService == null) {
            logger.error("1-37", "", "", "Failed to create nacos naming service client. Reason: server status check failed.");
            throw new IllegalStateException("Failed to create nacos naming service client. Reason: server status check failed.");
        }
        return new NacosNamingServiceWrapper(namingService, retryTimes, sleepMsBetweenRetries);
    }

    private static boolean testNamingService(NamingService namingService) {
        try {
            namingService.getAllInstances("Dubbo-Nacos-Test", false);
            return true;
        }
        catch (NacosException e) {
            return false;
        }
    }

    private static Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        NacosNamingServiceUtils.setServerAddr(url, properties);
        NacosNamingServiceUtils.setProperties(url, properties);
        return properties;
    }

    private static void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(':').append(url.getPort());
        String backup = url.getParameter("backup");
        if (StringUtils.isNotEmpty(backup)) {
            serverAddrBuilder.append(',').append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private static void setProperties(URL url, Properties properties) {
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "com.alibaba.nacos.naming.log.filename", null);
        Map<String, String> parameters = url.getParameters(StringConstantFieldValuePredicate.of(PropertyKeyConst.class));
        properties.putAll(parameters);
        if (StringUtils.isNotEmpty(url.getUsername())) {
            properties.put("username", url.getUsername());
        }
        if (StringUtils.isNotEmpty(url.getPassword())) {
            properties.put("password", url.getPassword());
        }
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName, String defaultValue) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty(propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        } else if (StringUtils.isNotEmpty(defaultValue)) {
            properties.setProperty(propertyName, defaultValue);
        }
    }
}

