/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.ProtocolServiceKey;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.AddressListener;
import org.apache.dubbo.registry.ProviderFirstParams;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.OverrideInstanceAddressURL;
import org.apache.dubbo.registry.integration.AbstractConfiguratorListener;
import org.apache.dubbo.registry.integration.DynamicDirectory;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class ServiceDiscoveryRegistryDirectory<T>
extends DynamicDirectory<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ServiceDiscoveryRegistryDirectory.class);
    private volatile Map<ProtocolServiceKeyWithAddress, Invoker<T>> urlInvokerMap;
    private volatile ReferenceConfigurationListener referenceConfigurationListener;
    private volatile boolean enableConfigurationListen = true;
    private volatile List<URL> originalUrls = null;
    private volatile Map<String, String> overrideQueryMap;
    private final Set<String> providerFirstParams;
    private final ModuleModel moduleModel;
    private final ProtocolServiceKey consumerProtocolServiceKey;
    private final Map<ProtocolServiceKey, URL> customizedConsumerUrlMap = new ConcurrentHashMap<ProtocolServiceKey, URL>();

    public ServiceDiscoveryRegistryDirectory(Class<T> serviceType, URL url) {
        super(serviceType, url);
        this.moduleModel = ScopeModelUtil.getModuleModel(url.getScopeModel());
        Set<ProviderFirstParams> providerFirstParams = url.getOrDefaultApplicationModel().getExtensionLoader(ProviderFirstParams.class).getSupportedExtensionInstances();
        if (CollectionUtils.isEmpty(providerFirstParams)) {
            this.providerFirstParams = null;
        } else if (providerFirstParams.size() == 1) {
            this.providerFirstParams = Collections.unmodifiableSet(providerFirstParams.iterator().next().params());
        } else {
            HashSet<String> params = new HashSet<String>();
            for (ProviderFirstParams paramsFilter : providerFirstParams) {
                if (paramsFilter.params() == null) break;
                params.addAll(paramsFilter.params());
            }
            this.providerFirstParams = Collections.unmodifiableSet(params);
        }
        String protocol = this.consumerUrl.getParameter("protocol", this.consumerUrl.getProtocol());
        this.consumerProtocolServiceKey = new ProtocolServiceKey(this.consumerUrl.getServiceInterface(), this.consumerUrl.getVersion(), this.consumerUrl.getGroup(), !"consumer".equals(protocol) ? protocol : null);
    }

    @Override
    public void subscribe(URL url) {
        if (this.moduleModel.getModelEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", true).booleanValue()) {
            this.enableConfigurationListen = true;
            this.getConsumerConfigurationListener(this.moduleModel).addNotifyListener(this);
            this.referenceConfigurationListener = new ReferenceConfigurationListener(this.moduleModel, this, url);
        } else {
            this.enableConfigurationListen = false;
        }
        super.subscribe(url);
    }

    private ConsumerConfigurationListener getConsumerConfigurationListener(ModuleModel moduleModel) {
        return moduleModel.getBeanFactory().getOrRegisterBean(ConsumerConfigurationListener.class, type -> new ConsumerConfigurationListener(moduleModel));
    }

    @Override
    public void unSubscribe(URL url) {
        super.unSubscribe(url);
        this.originalUrls = null;
        if (this.moduleModel.getModelEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", true).booleanValue()) {
            this.getConsumerConfigurationListener(this.moduleModel).removeNotifyListener(this);
            this.referenceConfigurationListener.stop();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.moduleModel.getModelEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", true).booleanValue()) {
            this.getConsumerConfigurationListener(this.moduleModel).removeNotifyListener(this);
            this.referenceConfigurationListener.stop();
        }
    }

    @Override
    public void buildRouterChain(URL url) {
        this.setRouterChain(RouterChain.buildChain(this.getInterface(), url.addParameter("registry-type", "service")));
    }

    @Override
    public synchronized void notify(List<URL> instanceUrls) {
        if (this.isDestroyed()) {
            return;
        }
        RpcServiceContext.getServiceContext().setConsumerUrl(this.getConsumerUrl());
        ExtensionLoader<AddressListener> addressListenerExtensionLoader = this.getUrl().getOrDefaultModuleModel().getExtensionLoader(AddressListener.class);
        List<AddressListener> supportedListeners = addressListenerExtensionLoader.getActivateExtension(this.getUrl(), (String[])null);
        if (supportedListeners != null && !supportedListeners.isEmpty()) {
            for (AddressListener addressListener : supportedListeners) {
                instanceUrls = addressListener.notify(instanceUrls, this.getConsumerUrl(), this);
            }
        }
        this.refreshOverrideAndInvoker(instanceUrls);
    }

    private synchronized void refreshOverrideAndInvoker(List<URL> instanceUrls) {
        this.refreshInvoker(instanceUrls);
    }

    private InstanceAddressURL overrideWithConfigurator(InstanceAddressURL providerUrl) {
        providerUrl = this.overrideWithConfigurators(this.getConsumerConfigurationListener(this.moduleModel).getConfigurators(), providerUrl);
        if (this.referenceConfigurationListener != null) {
            providerUrl = this.overrideWithConfigurators(this.referenceConfigurationListener.getConfigurators(), providerUrl);
        }
        return providerUrl;
    }

    private InstanceAddressURL overrideWithConfigurators(List<Configurator> configurators, InstanceAddressURL url) {
        if (CollectionUtils.isNotEmpty(configurators)) {
            OverrideInstanceAddressURL overrideInstanceAddressURL = new OverrideInstanceAddressURL(url);
            if (this.overrideQueryMap != null) {
                overrideInstanceAddressURL = (OverrideInstanceAddressURL)overrideInstanceAddressURL.addParameters(this.overrideQueryMap);
            }
            for (Configurator configurator : configurators) {
                overrideInstanceAddressURL = (OverrideInstanceAddressURL)configurator.configure(overrideInstanceAddressURL);
            }
            return overrideInstanceAddressURL;
        }
        return url;
    }

    @Override
    public boolean isServiceDiscovery() {
        return true;
    }

    @Override
    public boolean isNotificationReceived() {
        return this.serviceListener == null || this.serviceListener.isDestroyed() || this.serviceListener.getAllInstances().size() == this.serviceListener.getServiceNames().size();
    }

    private void refreshInvoker(List<URL> invokerUrls) {
        Assert.notNull(invokerUrls, "invokerUrls should not be null, use EMPTY url to clear current addresses.");
        this.originalUrls = invokerUrls;
        if (invokerUrls.size() == 1 && "empty".equals(invokerUrls.get(0).getProtocol())) {
            logger.warn("4-1", "", "", "Received url with EMPTY protocol, will clear all available addresses.");
            this.forbidden = true;
            this.routerChain.setInvokers(BitList.emptyList());
            this.destroyAllInvokers();
        } else {
            this.forbidden = false;
            if (CollectionUtils.isEmpty(invokerUrls)) {
                logger.warn("4-1", "", "", "Received empty url list, will ignore for protection purpose.");
                return;
            }
            Map<ProtocolServiceKeyWithAddress, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
            LinkedHashMap<ProtocolServiceKeyWithAddress, Invoker<T>> oldUrlInvokerMap = null;
            if (localUrlInvokerMap != null) {
                oldUrlInvokerMap = new LinkedHashMap<ProtocolServiceKeyWithAddress, Invoker<T>>(Math.round(1.0f + (float)localUrlInvokerMap.size() / 0.75f));
                localUrlInvokerMap.forEach(oldUrlInvokerMap::put);
            }
            Map<ProtocolServiceKeyWithAddress, Invoker<T>> newUrlInvokerMap = this.toInvokers(oldUrlInvokerMap, invokerUrls);
            logger.info("Refreshed invoker size " + newUrlInvokerMap.size());
            if (CollectionUtils.isEmptyMap(newUrlInvokerMap)) {
                logger.error("4-1", "", "", "Unsupported protocol.", new IllegalStateException("Cannot create invokers from url address list (total " + invokerUrls.size() + ")"));
                return;
            }
            List<Invoker<T>> newInvokers = Collections.unmodifiableList(new ArrayList<Invoker<T>>(newUrlInvokerMap.values()));
            this.setInvokers(this.multiGroup ? new BitList<Invoker<T>>(this.toMergeInvokerList(newInvokers)) : new BitList<Invoker<T>>(newInvokers));
            this.routerChain.setInvokers(this.getInvokers());
            this.urlInvokerMap = newUrlInvokerMap;
            if (oldUrlInvokerMap != null) {
                try {
                    this.destroyUnusedInvokers(oldUrlInvokerMap, newUrlInvokerMap);
                }
                catch (Exception e) {
                    logger.warn("4-17", "", "", "destroyUnusedInvokers error. ", e);
                }
            }
        }
        this.invokersChanged();
    }

    private Map<ProtocolServiceKeyWithAddress, Invoker<T>> toInvokers(Map<ProtocolServiceKeyWithAddress, Invoker<T>> oldUrlInvokerMap, List<URL> urls) {
        ConcurrentHashMap<ProtocolServiceKeyWithAddress, Invoker<T>> newUrlInvokerMap = new ConcurrentHashMap<ProtocolServiceKeyWithAddress, Invoker<T>>(urls == null ? 1 : (int)((float)urls.size() / 0.75f + 1.0f));
        if (urls == null || urls.isEmpty()) {
            return newUrlInvokerMap;
        }
        for (URL url : urls) {
            InstanceAddressURL instanceAddressURL = (InstanceAddressURL)url;
            if ("empty".equals(instanceAddressURL.getProtocol())) continue;
            if (!this.getUrl().getOrDefaultFrameworkModel().getExtensionLoader(Protocol.class).hasExtension(instanceAddressURL.getProtocol())) {
                logger.error("4-1", "protocol extension does not installed", "", "Unsupported protocol.", new IllegalStateException("Unsupported protocol " + instanceAddressURL.getProtocol() + " in notified url: " + instanceAddressURL + " from registry " + this.getUrl().getAddress() + " to consumer " + NetUtils.getLocalHost() + ", supported protocol: " + this.getUrl().getOrDefaultFrameworkModel().getExtensionLoader(Protocol.class).getSupportedExtensions()));
                continue;
            }
            instanceAddressURL.setProviderFirstParams(this.providerFirstParams);
            if (this.enableConfigurationListen) {
                instanceAddressURL = this.overrideWithConfigurator(instanceAddressURL);
            }
            int port = instanceAddressURL.getPort();
            List matchedProtocolServiceKeys = instanceAddressURL.getMetadataInfo().getMatchedServiceInfos(this.consumerProtocolServiceKey).stream().filter(serviceInfo -> serviceInfo.getPort() <= 0 || serviceInfo.getPort() == port).map(MetadataInfo.ServiceInfo::getProtocolServiceKey).collect(Collectors.toList());
            boolean shouldWrap = matchedProtocolServiceKeys.size() != 1 || !this.consumerProtocolServiceKey.isSameWith((ProtocolServiceKey)matchedProtocolServiceKeys.get(0));
            for (ProtocolServiceKey matchedProtocolServiceKey : matchedProtocolServiceKeys) {
                Invoker<T> invoker;
                ProtocolServiceKeyWithAddress protocolServiceKeyWithAddress = new ProtocolServiceKeyWithAddress(matchedProtocolServiceKey, instanceAddressURL.getAddress());
                Invoker<T> invoker2 = invoker = oldUrlInvokerMap == null ? null : oldUrlInvokerMap.get(protocolServiceKeyWithAddress);
                if (invoker == null || this.urlChanged(invoker, instanceAddressURL, matchedProtocolServiceKey)) {
                    try {
                        boolean enabled = instanceAddressURL.hasParameter("disabled") ? !instanceAddressURL.getParameter("disabled", false) : instanceAddressURL.getParameter("enabled", true);
                        if (enabled) {
                            if (shouldWrap) {
                                URL newConsumerUrl = this.customizedConsumerUrlMap.computeIfAbsent(matchedProtocolServiceKey, k -> this.consumerUrl.setProtocol(k.getProtocol()).addParameter("group", k.getGroup()).addParameter("version", k.getVersion()));
                                RpcContext.getServiceContext().setConsumerUrl(newConsumerUrl);
                                invoker = new InstanceWrappedInvoker(this.protocol.refer(this.serviceType, instanceAddressURL), newConsumerUrl, matchedProtocolServiceKey);
                            } else {
                                invoker = this.protocol.refer(this.serviceType, instanceAddressURL);
                            }
                        }
                    }
                    catch (Throwable t) {
                        logger.error("4-3", "", "", "Failed to refer invoker for interface:" + this.serviceType + ",url:(" + instanceAddressURL + ")" + t.getMessage(), t);
                    }
                    if (invoker == null) continue;
                    newUrlInvokerMap.put(protocolServiceKeyWithAddress, invoker);
                    continue;
                }
                newUrlInvokerMap.put(protocolServiceKeyWithAddress, invoker);
                oldUrlInvokerMap.remove(protocolServiceKeyWithAddress, invoker);
            }
        }
        return newUrlInvokerMap;
    }

    private boolean urlChanged(Invoker<T> invoker, InstanceAddressURL newURL, ProtocolServiceKey protocolServiceKey) {
        MetadataInfo.ServiceInfo oldServiceInfo;
        InstanceAddressURL oldURL = (InstanceAddressURL)invoker.getUrl();
        if (!newURL.getInstance().equals(oldURL.getInstance())) {
            return true;
        }
        if (oldURL instanceof OverrideInstanceAddressURL || newURL instanceof OverrideInstanceAddressURL) {
            if (!(oldURL instanceof OverrideInstanceAddressURL) || !(newURL instanceof OverrideInstanceAddressURL)) {
                return true;
            }
            if (!((OverrideInstanceAddressURL)oldURL).getOverrideParams().equals(((OverrideInstanceAddressURL)newURL).getOverrideParams())) {
                return true;
            }
        }
        if (null == (oldServiceInfo = oldURL.getMetadataInfo().getValidServiceInfo(protocolServiceKey.toString()))) {
            return false;
        }
        return !oldServiceInfo.equals(newURL.getMetadataInfo().getValidServiceInfo(protocolServiceKey.toString()));
    }

    private List<Invoker<T>> toMergeInvokerList(List<Invoker<T>> invokers) {
        ArrayList<Invoker<T>> mergedInvokers = new ArrayList();
        HashMap<String, List> groupMap = new HashMap<String, List>();
        for (Invoker<T> invoker : invokers) {
            String group = invoker.getUrl().getGroup("");
            groupMap.computeIfAbsent(group, k -> new ArrayList());
            ((List)groupMap.get(group)).add(invoker);
        }
        if (groupMap.size() == 1) {
            mergedInvokers.addAll((Collection)groupMap.values().iterator().next());
        } else if (groupMap.size() > 1) {
            for (List groupList : groupMap.values()) {
                StaticDirectory staticDirectory = new StaticDirectory(groupList);
                staticDirectory.buildRouterChain();
                mergedInvokers.add(this.cluster.join(staticDirectory, false));
            }
        } else {
            mergedInvokers = invokers;
        }
        return mergedInvokers;
    }

    @Override
    protected void destroyAllInvokers() {
        Map<ProtocolServiceKeyWithAddress, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        if (localUrlInvokerMap != null) {
            for (Invoker<T> invoker : new ArrayList<Invoker<T>>(localUrlInvokerMap.values())) {
                try {
                    invoker.destroy();
                }
                catch (Throwable t) {
                    logger.warn("4-17", "", "", "Failed to destroy service " + this.serviceKey + " to provider " + invoker.getUrl(), t);
                }
            }
            localUrlInvokerMap.clear();
        }
        this.urlInvokerMap = null;
        this.destroyInvokers();
    }

    private void destroyUnusedInvokers(Map<ProtocolServiceKeyWithAddress, Invoker<T>> oldUrlInvokerMap, Map<ProtocolServiceKeyWithAddress, Invoker<T>> newUrlInvokerMap) {
        if (newUrlInvokerMap == null || newUrlInvokerMap.size() == 0) {
            this.destroyAllInvokers();
            return;
        }
        if (oldUrlInvokerMap == null || oldUrlInvokerMap.size() == 0) {
            return;
        }
        for (Map.Entry<ProtocolServiceKeyWithAddress, Invoker<T>> entry : oldUrlInvokerMap.entrySet()) {
            Invoker<T> invoker = entry.getValue();
            if (invoker == null) continue;
            try {
                invoker.destroy();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("destroy invoker[" + invoker.getUrl() + "] success. ");
            }
            catch (Exception e) {
                logger.warn("4-17", "", "", "destroy invoker[" + invoker.getUrl() + "]failed." + e.getMessage(), e);
            }
        }
        logger.info(oldUrlInvokerMap.size() + " deprecated invokers deleted.");
    }

    public static final class InstanceWrappedInvoker<T>
    implements Invoker<T> {
        private final Invoker<T> originInvoker;
        private final URL newConsumerUrl;
        private final ProtocolServiceKey protocolServiceKey;

        public InstanceWrappedInvoker(Invoker<T> originInvoker, URL newConsumerUrl, ProtocolServiceKey protocolServiceKey) {
            this.originInvoker = originInvoker;
            this.newConsumerUrl = newConsumerUrl;
            this.protocolServiceKey = protocolServiceKey;
        }

        @Override
        public Class<T> getInterface() {
            return this.originInvoker.getInterface();
        }

        @Override
        public Result invoke(Invocation invocation) throws RpcException {
            RpcContext.getServiceContext().setConsumerUrl(this.newConsumerUrl);
            RpcInvocation copiedInvocation = new RpcInvocation(invocation.getTargetServiceUniqueName(), invocation.getServiceModel(), invocation.getMethodName(), invocation.getServiceName(), this.protocolServiceKey.toString(), invocation.getParameterTypes(), invocation.getArguments(), invocation.getObjectAttachments(), invocation.getInvoker(), invocation.getAttributes(), invocation instanceof RpcInvocation ? ((RpcInvocation)invocation).getInvokeMode() : null);
            copiedInvocation.setObjectAttachment("group", this.protocolServiceKey.getGroup());
            copiedInvocation.setObjectAttachment("version", this.protocolServiceKey.getVersion());
            return this.originInvoker.invoke(copiedInvocation);
        }

        @Override
        public URL getUrl() {
            RpcContext.getServiceContext().setConsumerUrl(this.newConsumerUrl);
            return this.originInvoker.getUrl();
        }

        @Override
        public boolean isAvailable() {
            RpcContext.getServiceContext().setConsumerUrl(this.newConsumerUrl);
            return this.originInvoker.isAvailable();
        }

        @Override
        public void destroy() {
            RpcContext.getServiceContext().setConsumerUrl(this.newConsumerUrl);
            this.originInvoker.destroy();
        }
    }

    public static final class ProtocolServiceKeyWithAddress
    extends ProtocolServiceKey {
        private final String address;

        public ProtocolServiceKeyWithAddress(ProtocolServiceKey protocolServiceKey, String address) {
            super(protocolServiceKey.getInterfaceName(), protocolServiceKey.getVersion(), protocolServiceKey.getGroup(), protocolServiceKey.getProtocol());
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ProtocolServiceKeyWithAddress that = (ProtocolServiceKeyWithAddress)o;
            return Objects.equals(this.address, that.address);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.address);
        }
    }

    private static class ConsumerConfigurationListener
    extends AbstractConfiguratorListener {
        private final List<ServiceDiscoveryRegistryDirectory<?>> listeners = new ArrayList();

        ConsumerConfigurationListener(ModuleModel moduleModel) {
            super(moduleModel);
        }

        void addNotifyListener(ServiceDiscoveryRegistryDirectory<?> listener) {
            if (this.listeners.size() == 0) {
                this.initWith(this.moduleModel.getApplicationModel().getApplicationName() + ".configurators");
            }
            this.listeners.add(listener);
        }

        void removeNotifyListener(ServiceDiscoveryRegistryDirectory<?> listener) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.stopListen(this.moduleModel.getApplicationModel().getApplicationName() + ".configurators");
            }
        }

        @Override
        protected void notifyOverrides() {
            this.listeners.forEach(listener -> {
                if (((ServiceDiscoveryRegistryDirectory)listener).originalUrls != null) {
                    URL backup = RpcContext.getServiceContext().getConsumerUrl();
                    RpcContext.getServiceContext().setConsumerUrl(listener.getConsumerUrl());
                    ((ServiceDiscoveryRegistryDirectory)listener).refreshOverrideAndInvoker(((ServiceDiscoveryRegistryDirectory)listener).originalUrls);
                    RpcContext.getServiceContext().setConsumerUrl(backup);
                }
            });
        }
    }

    private class ReferenceConfigurationListener
    extends AbstractConfiguratorListener {
        private final ServiceDiscoveryRegistryDirectory<?> directory;
        private final URL url;

        ReferenceConfigurationListener(ModuleModel moduleModel, ServiceDiscoveryRegistryDirectory<?> directory, URL url) {
            super(moduleModel);
            this.directory = directory;
            this.url = url;
            this.initWith(DynamicConfiguration.getRuleKey(url) + ".configurators");
        }

        void stop() {
            this.stopListen(DynamicConfiguration.getRuleKey(this.url) + ".configurators");
        }

        @Override
        protected void notifyOverrides() {
            if (((ServiceDiscoveryRegistryDirectory)this.directory).originalUrls != null) {
                URL backup = RpcContext.getServiceContext().getConsumerUrl();
                RpcContext.getServiceContext().setConsumerUrl(this.directory.getConsumerUrl());
                ((ServiceDiscoveryRegistryDirectory)this.directory).refreshOverrideAndInvoker(((ServiceDiscoveryRegistryDirectory)this.directory).originalUrls);
                RpcContext.getServiceContext().setConsumerUrl(backup);
            }
        }
    }
}

