/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.profiler.ProfilerSwitch;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;

@Cmd(name="setProfilerWarnPercent", example={"setProfilerWarnPercent 0.75"}, summary="Disable Dubbo Invocation Profiler.")
public class SetProfilerWarnPercent
implements BaseCommand {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SetProfilerWarnPercent.class);

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        if (args == null || args.length != 1) {
            return "args error. example: setProfilerWarnPercent 0.75";
        }
        ProfilerSwitch.setWarnPercent(Double.parseDouble(args[0]));
        logger.warn("7-3", "", "", "Dubbo Invocation Profiler warn percent has been set to " + args[0]);
        return "OK";
    }
}

