/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.monitor.support;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.monitor.Monitor;
import org.apache.dubbo.monitor.MonitorFactory;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"provider"})
public class MonitorFilter
implements Filter,
BaseFilter.Listener {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(MonitorFilter.class);
    private static final String MONITOR_FILTER_START_TIME = "monitor_filter_start_time";
    private static final String MONITOR_REMOTE_HOST_STORE = "monitor_remote_host_store";
    private final ConcurrentMap<String, AtomicInteger> concurrents = new ConcurrentHashMap<String, AtomicInteger>();
    private MonitorFactory monitorFactory;

    public void setMonitorFactory(MonitorFactory monitorFactory) {
        this.monitorFactory = monitorFactory;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (invoker.getUrl().hasAttribute("monitor")) {
            invocation.put(MONITOR_FILTER_START_TIME, System.currentTimeMillis());
            invocation.put(MONITOR_REMOTE_HOST_STORE, RpcContext.getServiceContext().getRemoteHost());
            this.getConcurrent(invoker, invocation).incrementAndGet();
        }
        return invoker.invoke(invocation);
    }

    private AtomicInteger getConcurrent(Invoker<?> invoker, Invocation invocation) {
        String key = invoker.getInterface().getName() + "." + invocation.getMethodName();
        return this.concurrents.computeIfAbsent(key, k -> new AtomicInteger());
    }

    @Override
    public void onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        if (invoker.getUrl().hasAttribute("monitor")) {
            Long startTime = (Long)invocation.get(MONITOR_FILTER_START_TIME);
            if (startTime != null) {
                this.collect(invoker, invocation, result, (String)invocation.get(MONITOR_REMOTE_HOST_STORE), startTime, false);
            }
            this.getConcurrent(invoker, invocation).decrementAndGet();
        }
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        if (invoker.getUrl().hasAttribute("monitor")) {
            Long startTime = (Long)invocation.get(MONITOR_FILTER_START_TIME);
            if (startTime != null) {
                this.collect(invoker, invocation, null, (String)invocation.get(MONITOR_REMOTE_HOST_STORE), startTime, true);
            }
            this.getConcurrent(invoker, invocation).decrementAndGet();
        }
    }

    private void collect(Invoker<?> invoker, Invocation invocation, Result result, String remoteHost, long start, boolean error) {
        try {
            Object monitorUrl = invoker.getUrl().getAttribute("monitor");
            if (monitorUrl instanceof URL) {
                Monitor monitor = this.monitorFactory.getMonitor((URL)monitorUrl);
                if (monitor == null) {
                    return;
                }
                URL statisticsUrl = this.createStatisticsUrl(invoker, invocation, result, remoteHost, start, error);
                monitor.collect(statisticsUrl.toSerializableURL());
            }
        }
        catch (Throwable t) {
            logger.warn("0-14", "", "", "Failed to monitor count service " + invoker.getUrl() + ", cause: " + t.getMessage(), t);
        }
    }

    private URL createStatisticsUrl(Invoker<?> invoker, Invocation invocation, Result result, String remoteHost, long start, boolean error) {
        String remoteValue;
        String remoteKey;
        int localPort;
        long elapsed = System.currentTimeMillis() - start;
        int concurrent = this.getConcurrent(invoker, invocation).get();
        String application = invoker.getUrl().getApplication();
        String service = invoker.getInterface().getName();
        String method = RpcUtils.getMethodName(invocation);
        String group = invoker.getUrl().getGroup();
        String version = invoker.getUrl().getVersion();
        if ("consumer".equals(invoker.getUrl().getSide())) {
            localPort = 0;
            remoteKey = "provider";
            remoteValue = invoker.getUrl().getAddress();
        } else {
            localPort = invoker.getUrl().getPort();
            remoteKey = "consumer";
            remoteValue = remoteHost;
        }
        String input = "";
        String output = "";
        if (invocation.getAttachment("input") != null) {
            input = invocation.getAttachment("input");
        }
        if (result != null && result.getAttachment("output") != null) {
            output = result.getAttachment("output");
        }
        return new ServiceConfigURL("count", NetUtils.getLocalHost(), localPort, service + "/" + method, "application", application, "interface", service, "method", method, remoteKey, remoteValue, error ? "failure" : "success", "1", "elapsed", String.valueOf(elapsed), "concurrent", String.valueOf(concurrent), "input", input, "output", output, "group", group, "version", version);
    }
}

