/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.filter;

import java.util.function.Consumer;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.filter.MetricsCollectExecutor;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

@Activate(group={"provider"}, order=-1)
public class MetricsFilter
implements Filter,
BaseFilter.Listener,
ScopeModelAware {
    private DefaultMetricsCollector collector = null;
    private ApplicationModel applicationModel;

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.collector = applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class);
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (this.collector == null || !this.collector.isCollectEnabled().booleanValue()) {
            return invoker.invoke(invocation);
        }
        this.collect(invocation, MetricsCollectExecutor::beforeExecute);
        return invoker.invoke(invocation);
    }

    @Override
    public void onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        this.collect(invocation, collector -> collector.postExecute(result));
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        this.collect(invocation, collector -> collector.throwExecute(t));
    }

    private void collect(Invocation invocation, Consumer<MetricsCollectExecutor> execute) {
        MetricsCollectExecutor collectorExecutor = new MetricsCollectExecutor(this.collector, invocation);
        execute.accept(collectorExecutor);
    }
}

