/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2;

import java.util.Arrays;
import java.util.Set;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.AllowClassNotifyListener;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.SerializeCheckStatus;
import org.apache.dubbo.common.utils.SerializeSecurityManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class Hessian2AllowClassManager
implements AllowClassNotifyListener {
    private static final long MAGIC_HASH_CODE = -3750763034362895579L;
    private static final long MAGIC_PRIME = 1099511628211L;
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(Hessian2AllowClassManager.class);
    private volatile SerializeCheckStatus checkStatus = AllowClassNotifyListener.DEFAULT_STATUS;
    private static final Set<String> warnedClasses = new ConcurrentHashSet<String>(1);
    private volatile long[] allowPrefixes = new long[0];

    public Hessian2AllowClassManager(FrameworkModel frameworkModel) {
        SerializeSecurityManager serializeSecurityManager = frameworkModel.getBeanFactory().getOrRegisterBean(SerializeSecurityManager.class);
        serializeSecurityManager.registerListener(this);
    }

    @Override
    public void notify(SerializeCheckStatus status, Set<String> prefixList) {
        this.checkStatus = status;
        long[] array = new long[prefixList.size()];
        int index = 0;
        for (String name : prefixList) {
            if (name == null || name.isEmpty()) continue;
            long hashCode = -3750763034362895579L;
            for (int j = 0; j < name.length(); ++j) {
                int ch = name.charAt(j);
                if (ch == 36) {
                    ch = 46;
                }
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
            array[index++] = hashCode;
        }
        if (index != array.length) {
            array = Arrays.copyOf(array, index);
        }
        Arrays.sort(array);
        this.allowPrefixes = array;
    }

    public Class<?> loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        if (this.checkStatus == SerializeCheckStatus.DISABLED) {
            return Class.forName(className, false, classLoader);
        }
        long hash = -3750763034362895579L;
        int typeNameLength = className.length();
        for (int i = 0; i < typeNameLength; ++i) {
            int ch = className.charAt(i);
            if (ch == 36) {
                ch = 46;
            }
            hash ^= (long)ch;
            if (Arrays.binarySearch(this.allowPrefixes, hash *= 1099511628211L) < 0) continue;
            return Class.forName(className, false, classLoader);
        }
        if (this.checkStatus == SerializeCheckStatus.STRICT) {
            String msg = "[Serialization Security] Serialized class " + className + " is not in allow list. Current mode is `STRICT`, will disallow to deserialize it by default. Please add it into security/serialize.allowlist or follow FAQ to configure it.";
            if (warnedClasses.add(className)) {
                logger.error("4-21", "", "", msg);
            }
            throw new IllegalArgumentException(msg);
        }
        Class<?> clazz = Class.forName(className, false, classLoader);
        if (warnedClasses.add(className)) {
            logger.error("4-21", "", "", "[Serialization Security] Serialized class " + clazz.getName() + " is not in allow list. Current mode is `WARN`, will allow to deserialize it by default. Dubbo will set to `STRICT` mode by default in the future. Please add it into security/serialize.allowlist or follow FAQ to configure it.");
        }
        return clazz;
    }
}

