/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson2;

import com.alibaba.fastjson2.filter.ContextAutoTypeBeforeHandler;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.util.TypeUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.AllowClassNotifyListener;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.SerializeCheckStatus;
import org.apache.dubbo.common.utils.SerializeSecurityManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class Fastjson2SecurityManager
implements AllowClassNotifyListener {
    private Filter securityFilter = new Handler(AllowClassNotifyListener.DEFAULT_STATUS, new String[0]);
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(Fastjson2SecurityManager.class);
    private static final Set<String> warnedClasses = new ConcurrentHashSet<String>(1);

    public Fastjson2SecurityManager(FrameworkModel frameworkModel) {
        SerializeSecurityManager securityManager = frameworkModel.getBeanFactory().getOrRegisterBean(SerializeSecurityManager.class);
        securityManager.registerListener(this);
    }

    @Override
    public void notify(SerializeCheckStatus status, Set<String> prefixList) {
        this.securityFilter = new Handler(status, prefixList.toArray(new String[0]));
    }

    public Filter getSecurityFilter() {
        return this.securityFilter;
    }

    public static class Handler
    extends ContextAutoTypeBeforeHandler {
        final SerializeCheckStatus status;
        final Map<String, Class<?>> classCache = new ConcurrentHashMap(16, 0.75f, 1);

        public Handler(SerializeCheckStatus status, String[] acceptNames) {
            super(true, acceptNames);
            this.status = status;
        }

        public Class<?> apply(String typeName, Class<?> expectClass, long features) {
            Class tryLoad = super.apply(typeName, expectClass, features);
            if (tryLoad != null) {
                return tryLoad;
            }
            if (this.status == SerializeCheckStatus.STRICT) {
                String msg = "[Serialization Security] Serialized class " + typeName + " is not in allow list. Current mode is `STRICT`, will disallow to deserialize it by default. Please add it into security/serialize.allowlist or follow FAQ to configure it.";
                if (warnedClasses.add(typeName)) {
                    logger.error("4-21", "", "", msg);
                }
                return null;
            }
            Class<?> localClass = this.loadClassDirectly(typeName);
            if (localClass != null) {
                if (this.status == SerializeCheckStatus.WARN && warnedClasses.add(typeName)) {
                    logger.error("4-21", "", "", "[Serialization Security] Serialized class " + localClass.getName() + " is not in allow list. Current mode is `WARN`, will allow to deserialize it by default. Dubbo will set to `STRICT` mode by default in the future. Please add it into security/serialize.allowlist or follow FAQ to configure it.");
                }
                return localClass;
            }
            return null;
        }

        public Class<?> loadClassDirectly(String typeName) {
            Class origin;
            Class clazz = this.classCache.get(typeName);
            if (clazz == null) {
                clazz = TypeUtils.getMapping((String)typeName);
            }
            if (clazz == null) {
                clazz = TypeUtils.loadClass((String)typeName);
            }
            if (clazz != null && (origin = this.classCache.putIfAbsent(typeName, clazz)) != null) {
                clazz = origin;
            }
            return clazz;
        }
    }
}

