/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.serialize.fastjson2.FastJson2ObjectInput;
import org.apache.dubbo.common.serialize.fastjson2.FastJson2ObjectOutput;
import org.apache.dubbo.common.serialize.fastjson2.Fastjson2CreatorManager;
import org.apache.dubbo.common.serialize.fastjson2.Fastjson2SecurityManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class FastJson2Serialization
implements Serialization {
    private final Fastjson2CreatorManager fastjson2CreatorManager;
    private final Fastjson2SecurityManager fastjson2SecurityManager;

    public FastJson2Serialization(FrameworkModel frameworkModel) {
        this.fastjson2CreatorManager = frameworkModel.getBeanFactory().getBean(Fastjson2CreatorManager.class);
        this.fastjson2SecurityManager = frameworkModel.getBeanFactory().getBean(Fastjson2SecurityManager.class);
    }

    @Override
    public byte getContentTypeId() {
        return 23;
    }

    @Override
    public String getContentType() {
        return "text/jsonb";
    }

    @Override
    public ObjectOutput serialize(URL url, OutputStream output) throws IOException {
        return new FastJson2ObjectOutput(this.fastjson2CreatorManager, output);
    }

    @Override
    public ObjectInput deserialize(URL url, InputStream input) throws IOException {
        return new FastJson2ObjectInput(this.fastjson2CreatorManager, this.fastjson2SecurityManager, input);
    }
}

