/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.Parameters;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.ExchangeHandler;
import org.apache.dubbo.rpc.protocol.dubbo.LazyConnectExchangeClient;

final class ReferenceCountExchangeClient
implements ExchangeClient {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ReferenceCountExchangeClient.class);
    private final URL url;
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private final AtomicInteger disconnectCount = new AtomicInteger(0);
    private static final Integer warningPeriod = 50;
    private ExchangeClient client;
    private int shutdownWaitTime = 10000;

    public ReferenceCountExchangeClient(ExchangeClient client, String codec) {
        this.client = client;
        this.referenceCount.incrementAndGet();
        this.url = client.getUrl();
    }

    @Override
    public void reset(URL url) {
        this.client.reset(url);
    }

    @Override
    public CompletableFuture<Object> request(Object request) throws RemotingException {
        return this.client.request(request);
    }

    @Override
    public URL getUrl() {
        return this.client.getUrl();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.client.getRemoteAddress();
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return this.client.getChannelHandler();
    }

    @Override
    public CompletableFuture<Object> request(Object request, int timeout) throws RemotingException {
        return this.client.request(request, timeout);
    }

    @Override
    public CompletableFuture<Object> request(Object request, ExecutorService executor) throws RemotingException {
        return this.client.request(request, executor);
    }

    @Override
    public CompletableFuture<Object> request(Object request, int timeout, ExecutorService executor) throws RemotingException {
        return this.client.request(request, timeout, executor);
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public void reconnect() throws RemotingException {
        this.client.reconnect();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.client.getLocalAddress();
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.client.hasAttribute(key);
    }

    @Override
    public void reset(Parameters parameters) {
        this.client.reset(parameters);
    }

    @Override
    public void send(Object message) throws RemotingException {
        this.client.send(message);
    }

    @Override
    public ExchangeHandler getExchangeHandler() {
        return this.client.getExchangeHandler();
    }

    @Override
    public Object getAttribute(String key) {
        return this.client.getAttribute(key);
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {
        this.client.send(message, sent);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.client.setAttribute(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.client.removeAttribute(key);
    }

    @Override
    public void close() {
        this.close(0);
    }

    @Override
    public void close(int timeout) {
        this.closeInternal(timeout, false);
    }

    @Override
    public void closeAll(int timeout) {
        this.closeInternal(timeout, true);
    }

    private void closeInternal(int timeout, boolean closeAll) {
        if (closeAll || this.referenceCount.decrementAndGet() <= 0) {
            if (timeout == 0) {
                this.client.close();
            } else {
                this.client.close(timeout);
            }
            this.replaceWithLazyClient();
        }
    }

    @Override
    public void startClose() {
        this.client.startClose();
    }

    private void replaceWithLazyClient() {
        if (this.disconnectCount.getAndIncrement() % warningPeriod == 1) {
            logger.warn("4-11", "", "", this.url.getAddress() + " " + this.url.getServiceKey() + " safe guard client , should not be called ,must have a bug.");
        }
        if (!(this.client instanceof LazyConnectExchangeClient)) {
            this.client = new LazyConnectExchangeClient(this.url, this.client.getExchangeHandler());
        }
    }

    @Override
    public boolean isClosed() {
        return this.client.isClosed();
    }

    public void incrementAndGetCount() {
        this.referenceCount.incrementAndGet();
    }

    public int getCount() {
        return this.referenceCount.get();
    }

    public int getShutdownWaitTime() {
        return this.shutdownWaitTime;
    }

    public void setShutdownWaitTime(int shutdownWaitTime) {
        this.shutdownWaitTime = shutdownWaitTime;
    }
}

