/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.transport.AbstractEndpoint;

public abstract class AbstractServer
extends AbstractEndpoint
implements RemotingServer {
    protected static final String SERVER_THREAD_POOL_NAME = "DubboServerHandler";
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractServer.class);
    private Set<ExecutorService> executors = new ConcurrentHashSet<ExecutorService>();
    private InetSocketAddress localAddress;
    private InetSocketAddress bindAddress;
    private int accepts;
    private ExecutorRepository executorRepository;

    public AbstractServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
        this.executorRepository = url.getOrDefaultApplicationModel().getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
        this.localAddress = this.getUrl().toInetSocketAddress();
        String bindIp = this.getUrl().getParameter("bind.ip", this.getUrl().getHost());
        int bindPort = this.getUrl().getParameter("bind.port", this.getUrl().getPort());
        if (url.getParameter("anyhost", false) || NetUtils.isInvalidLocalHost(bindIp)) {
            bindIp = "0.0.0.0";
        }
        this.bindAddress = new InetSocketAddress(bindIp, bindPort);
        this.accepts = url.getParameter("accepts", 0);
        try {
            this.doOpen();
            if (logger.isInfoEnabled()) {
                logger.info("Start " + this.getClass().getSimpleName() + " bind " + this.getBindAddress() + ", export " + this.getLocalAddress());
            }
        }
        catch (Throwable t) {
            throw new RemotingException(url.toInetSocketAddress(), null, "Failed to bind " + this.getClass().getSimpleName() + " on " + this.bindAddress + ", cause: " + t.getMessage(), t);
        }
        this.executors.add(this.executorRepository.createExecutorIfAbsent(url));
    }

    protected abstract void doOpen() throws Throwable;

    protected abstract void doClose() throws Throwable;

    @Override
    public void reset(URL url) {
        if (url == null) {
            return;
        }
        try {
            int a;
            if (url.hasParameter("accepts") && (a = url.getParameter("accepts", 0)) > 0) {
                this.accepts = a;
            }
        }
        catch (Throwable t) {
            logger.error("6-4", "", "", t.getMessage(), t);
        }
        ExecutorService executor = this.executorRepository.createExecutorIfAbsent(url);
        this.executors.add(executor);
        this.executorRepository.updateThreadpool(url, executor);
        super.setUrl(this.getUrl().addParameters(url.getParameters()));
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {
        Collection<Channel> channels = this.getChannels();
        for (Channel channel : channels) {
            if (!channel.isConnected()) continue;
            channel.send(message, sent);
        }
    }

    @Override
    public void close() {
        if (logger.isInfoEnabled()) {
            logger.info("Close " + this.getClass().getSimpleName() + " bind " + this.getBindAddress() + ", export " + this.getLocalAddress());
        }
        for (ExecutorService executor : this.executors) {
            ExecutorUtil.shutdownNow(executor, 100);
        }
        try {
            super.close();
        }
        catch (Throwable e) {
            logger.warn("6-4", "", "", e.getMessage(), e);
        }
        try {
            this.doClose();
        }
        catch (Throwable e) {
            logger.warn("6-4", "", "", e.getMessage(), e);
        }
    }

    @Override
    public void close(int timeout) {
        for (ExecutorService executor : this.executors) {
            ExecutorUtil.gracefulShutdown(executor, timeout);
        }
        this.close();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public int getAccepts() {
        return this.accepts;
    }

    @Override
    public void connected(Channel ch) throws RemotingException {
        if (this.isClosing() || this.isClosed()) {
            logger.warn("6-4", "", "", "Close new channel " + ch + ", cause: server is closing or has been closed. For example, receive a new connect request while in shutdown process.");
            ch.close();
            return;
        }
        if (this.accepts > 0 && this.getChannels().size() > this.accepts) {
            logger.error("6-4", "", "", "Close channel " + ch + ", cause: The server " + ch.getLocalAddress() + " connections greater than max config " + this.accepts);
            ch.close();
            return;
        }
        super.connected(ch);
    }

    @Override
    public void disconnected(Channel ch) throws RemotingException {
        Collection<Channel> channels = this.getChannels();
        if (channels.isEmpty()) {
            logger.warn("6-4", "", "", "All clients has disconnected from " + ch.getLocalAddress() + ". You can graceful shutdown now.");
        }
        super.disconnected(ch);
    }
}

