/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.api.pu.AbstractPortUnificationServer;
import org.apache.dubbo.remoting.api.pu.PortUnificationTransporter;

public class PortUnificationExchanger {
    private static final ErrorTypeAwareLogger log = LoggerFactory.getErrorTypeAwareLogger(PortUnificationExchanger.class);
    private static final ConcurrentMap<String, RemotingServer> servers = new ConcurrentHashMap<String, RemotingServer>();

    public static RemotingServer bind(URL url, ChannelHandler handler) {
        servers.computeIfAbsent(url.getAddress(), addr -> {
            AbstractPortUnificationServer server;
            try {
                server = PortUnificationExchanger.getTransporter(url).bind(url, handler);
            }
            catch (RemotingException e) {
                throw new RuntimeException(e);
            }
            return server;
        });
        servers.computeIfPresent(url.getAddress(), (addr, server) -> {
            ((AbstractPortUnificationServer)server).addSupportedProtocol(url, handler);
            return server;
        });
        return (RemotingServer)servers.get(url.getAddress());
    }

    public static void close() {
        ArrayList toClose = new ArrayList(servers.values());
        servers.clear();
        for (RemotingServer server : toClose) {
            try {
                server.close();
            }
            catch (Throwable throwable) {
                log.error("4-8", "", "", "Close all port unification server failed", throwable);
            }
        }
    }

    public static ConcurrentMap<String, RemotingServer> getServers() {
        return servers;
    }

    public static PortUnificationTransporter getTransporter(URL url) {
        return url.getOrDefaultFrameworkModel().getExtensionLoader(PortUnificationTransporter.class).getAdaptiveExtension();
    }
}

