/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.spring.util.AnnotationUtils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements MergedBeanDefinitionPostProcessor,
BeanFactoryAware,
BeanClassLoaderAware,
EnvironmentAware,
DisposableBean {
    private static final int CACHE_SIZE = Integer.getInteger("", 32);
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Class<? extends Annotation>[] annotationTypes;
    private final ConcurrentMap<String, AnnotatedInjectionMetadata> injectionMetadataCache = new ConcurrentHashMap<String, AnnotatedInjectionMetadata>(CACHE_SIZE);
    private ConfigurableListableBeanFactory beanFactory;
    private Environment environment;
    private ClassLoader classLoader;
    private int order = Integer.MAX_VALUE;

    public AbstractAnnotationBeanPostProcessor(Class<? extends Annotation> ... annotationTypes) {
        Assert.notEmpty((Object[])annotationTypes, (String)"The argument of annotations' types must not empty");
        this.annotationTypes = annotationTypes;
    }

    private static <T> Collection<T> combine(Collection<? extends T> ... elements) {
        ArrayList<? extends T> allElements = new ArrayList<T>();
        for (Collection<? extends T> e : elements) {
            allElements.addAll(e);
        }
        return allElements;
    }

    @Deprecated
    public final Class<? extends Annotation> getAnnotationType() {
        return this.annotationTypes[0];
    }

    protected final Class<? extends Annotation>[] getAnnotationTypes() {
        return this.annotationTypes;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"AnnotationInjectedBeanPostProcessor requires a ConfigurableListableBeanFactory");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    private List<AnnotatedFieldElement> findFieldAnnotationMetadata(Class<?> beanClass) {
        LinkedList<AnnotatedFieldElement> elements = new LinkedList<AnnotatedFieldElement>();
        ReflectionUtils.doWithFields(beanClass, field -> {
            for (Class<? extends Annotation> annotationType : this.getAnnotationTypes()) {
                AnnotationAttributes attributes = AnnotationUtils.getAnnotationAttributes((AnnotatedElement)field, annotationType, (PropertyResolver)this.getEnvironment(), (boolean)true, (boolean)true, (String[])new String[0]);
                if (attributes == null) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("@" + annotationType.getName() + " is not supported on static fields: " + field));
                    }
                    return;
                }
                elements.add(new AnnotatedFieldElement(field, attributes));
            }
        });
        return elements;
    }

    private List<AnnotatedMethodElement> findAnnotatedMethodMetadata(Class<?> beanClass) {
        LinkedList<AnnotatedMethodElement> elements = new LinkedList<AnnotatedMethodElement>();
        ReflectionUtils.doWithMethods(beanClass, method -> {
            Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
            if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, (Method)bridgedMethod)) {
                return;
            }
            if (method.getAnnotation(Bean.class) != null) {
                return;
            }
            for (Class<? extends Annotation> annotationType : this.getAnnotationTypes()) {
                AnnotationAttributes attributes = AnnotationUtils.getAnnotationAttributes((AnnotatedElement)bridgedMethod, annotationType, (PropertyResolver)this.getEnvironment(), (boolean)true, (boolean)true, (String[])new String[0]);
                if (attributes == null || !method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)beanClass))) continue;
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalStateException("When using @" + annotationType.getName() + " to inject interface proxy, it is not supported on static methods: " + method);
                }
                if (method.getParameterTypes().length != 1) {
                    throw new IllegalStateException("When using @" + annotationType.getName() + " to inject interface proxy, the method must have only one parameter: " + method);
                }
                PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, (Class)beanClass);
                elements.add(new AnnotatedMethodElement(method, pd, attributes));
            }
        });
        return elements;
    }

    private AnnotatedInjectionMetadata buildAnnotatedMetadata(Class<?> beanClass) {
        List<AnnotatedFieldElement> fieldElements = this.findFieldAnnotationMetadata(beanClass);
        List<AnnotatedMethodElement> methodElements = this.findAnnotatedMethodMetadata(beanClass);
        return new AnnotatedInjectionMetadata(beanClass, fieldElements, methodElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnnotatedInjectionMetadata findInjectionMetadata(String beanName, Class<?> clazz, PropertyValues pvs) {
        String cacheKey = StringUtils.hasLength((String)beanName) ? beanName : clazz.getName();
        AnnotatedInjectionMetadata metadata = (AnnotatedInjectionMetadata)((Object)this.injectionMetadataCache.get(cacheKey));
        if (this.needsRefreshInjectionMetadata(metadata, clazz)) {
            ConcurrentMap<String, AnnotatedInjectionMetadata> concurrentMap = this.injectionMetadataCache;
            synchronized (concurrentMap) {
                metadata = (AnnotatedInjectionMetadata)((Object)this.injectionMetadataCache.get(cacheKey));
                if (this.needsRefreshInjectionMetadata(metadata, clazz)) {
                    if (metadata != null) {
                        metadata.clear(pvs);
                    }
                    try {
                        metadata = this.buildAnnotatedMetadata(clazz);
                        this.injectionMetadataCache.put(cacheKey, metadata);
                    }
                    catch (NoClassDefFoundError err) {
                        throw new IllegalStateException("Failed to introspect object class [" + clazz.getName() + "] for annotation metadata: could not find class that it depends on", err);
                    }
                }
            }
        }
        return metadata;
    }

    private boolean needsRefreshInjectionMetadata(AnnotatedInjectionMetadata metadata, Class<?> clazz) {
        return metadata == null || metadata.needsRefresh(clazz);
    }

    public void destroy() throws Exception {
        this.injectionMetadataCache.clear();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(((Object)((Object)this)).getClass() + " was destroying!"));
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected Object getInjectedObject(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, AnnotatedInjectElement injectedElement) throws Exception {
        return this.doGetInjectedBean(attributes, bean, beanName, injectedType, injectedElement);
    }

    protected void prepareInjection(AnnotatedInjectionMetadata metadata) throws Exception {
    }

    protected abstract Object doGetInjectedBean(AnnotationAttributes var1, Object var2, String var3, Class<?> var4, AnnotatedInjectElement var5) throws Exception;

    public class AnnotatedFieldElement
    extends AnnotatedInjectElement {
        protected final Field field;

        protected AnnotatedFieldElement(Field field, AnnotationAttributes attributes) {
            super(field, null, attributes);
            this.field = field;
        }
    }

    protected class AnnotatedMethodElement
    extends AnnotatedInjectElement {
        protected final Method method;

        protected AnnotatedMethodElement(Method method, PropertyDescriptor pd, AnnotationAttributes attributes) {
            super(method, pd, attributes);
            this.method = method;
        }
    }

    protected class AnnotatedInjectElement
    extends InjectionMetadata.InjectedElement {
        protected final AnnotationAttributes attributes;
        protected volatile Object injectedObject;
        private Class<?> injectedType;

        protected AnnotatedInjectElement(Member member, PropertyDescriptor pd, AnnotationAttributes attributes) {
            super(member, pd);
            this.attributes = attributes;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Object injectedObject = AbstractAnnotationBeanPostProcessor.this.getInjectedObject(this.attributes, bean, beanName, this.getInjectedType(), this);
            if (this.member instanceof Field) {
                Field field = (Field)this.member;
                ReflectionUtils.makeAccessible((Field)field);
                field.set(bean, injectedObject);
            } else if (this.member instanceof Method) {
                Method method = (Method)this.member;
                ReflectionUtils.makeAccessible((Method)method);
                method.invoke(bean, injectedObject);
            }
        }

        public Class<?> getInjectedType() throws ClassNotFoundException {
            if (this.injectedType == null) {
                if (this.isField) {
                    this.injectedType = ((Field)this.member).getType();
                } else {
                    if (this.pd != null) {
                        return this.pd.getPropertyType();
                    }
                    Method method = (Method)this.member;
                    if (method.getParameterTypes().length > 0) {
                        this.injectedType = method.getParameterTypes()[0];
                    } else {
                        throw new IllegalStateException("get injected type failed");
                    }
                }
            }
            return this.injectedType;
        }

        public String getPropertyName() {
            if (this.member instanceof Field) {
                Field field = (Field)this.member;
                return field.getName();
            }
            if (this.pd != null) {
                return this.pd.getName();
            }
            Method method = (Method)this.member;
            return method.getName();
        }
    }

    protected static class AnnotatedInjectionMetadata
    extends InjectionMetadata {
        private Class<?> targetClass;
        private final Collection<AnnotatedFieldElement> fieldElements;
        private final Collection<AnnotatedMethodElement> methodElements;

        public AnnotatedInjectionMetadata(Class<?> targetClass, Collection<AnnotatedFieldElement> fieldElements, Collection<AnnotatedMethodElement> methodElements) {
            super(targetClass, AbstractAnnotationBeanPostProcessor.combine(new Collection[]{fieldElements, methodElements}));
            this.targetClass = targetClass;
            this.fieldElements = fieldElements;
            this.methodElements = methodElements;
        }

        public Collection<AnnotatedFieldElement> getFieldElements() {
            return this.fieldElements;
        }

        public Collection<AnnotatedMethodElement> getMethodElements() {
            return this.methodElements;
        }

        protected boolean needsRefresh(Class<?> clazz) {
            if (this.targetClass == clazz) {
                return false;
            }
            return !this.targetClass.isAssignableFrom(clazz) || !clazz.getName().contains("$$EnhancerBySpringCGLIB$$");
        }
    }
}

