/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.client.metadata.MetadataServiceDelegation;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigurableMetadataServiceExporter {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private MetadataServiceDelegation metadataService;
    private volatile ServiceConfig<MetadataService> serviceConfig;
    private final ApplicationModel applicationModel;

    public ConfigurableMetadataServiceExporter(ApplicationModel applicationModel, MetadataServiceDelegation metadataService) {
        this.applicationModel = applicationModel;
        this.metadataService = metadataService;
    }

    public synchronized ConfigurableMetadataServiceExporter export() {
        if (this.serviceConfig == null || !this.isExported()) {
            this.serviceConfig = this.buildServiceConfig();
            this.serviceConfig.export();
            this.metadataService.setMetadataURL(this.serviceConfig.getExportedUrls().get(0));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The MetadataService exports urls : " + this.serviceConfig.getExportedUrls());
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("5-26", "", "", "The MetadataService has been exported : " + this.serviceConfig.getExportedUrls());
        }
        return this;
    }

    public ConfigurableMetadataServiceExporter unexport() {
        if (this.isExported()) {
            this.serviceConfig.unexport();
            this.metadataService.setMetadataURL(null);
        }
        return this;
    }

    public boolean isExported() {
        return this.serviceConfig != null && this.serviceConfig.isExported() && !this.serviceConfig.isUnexported();
    }

    private ApplicationConfig getApplicationConfig() {
        return this.applicationModel.getApplicationConfigManager().getApplication().get();
    }

    private ProtocolConfig getProtocolConfig(String protocol) {
        return this.applicationModel.getApplicationConfigManager().getProtocol(protocol).get();
    }

    private ProtocolConfig generateMetadataProtocol() {
        ProtocolConfig protocolConfig;
        String specifiedProtocol;
        block10: {
            specifiedProtocol = this.getSpecifiedProtocol();
            Integer port = this.getSpecifiedPort();
            protocolConfig = new ProtocolConfig();
            protocolConfig.setName(specifiedProtocol);
            if (port == null || port < -1) {
                try {
                    Protocol protocol;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Metadata Service Port hasn't been set will use default protocol defined in protocols.");
                    }
                    if ((protocol = this.applicationModel.getExtensionLoader(Protocol.class).getExtension(specifiedProtocol)) == null || protocol.getServers() == null) break block10;
                    Iterator<ProtocolServer> it = protocol.getServers().iterator();
                    if (it.hasNext()) {
                        ProtocolServer server = it.next();
                        String rawPort = server.getUrl().getParameter("bind.port");
                        if (rawPort == null) {
                            String addr = server.getAddress();
                            rawPort = addr.substring(addr.indexOf(":") + 1);
                        }
                        protocolConfig.setPort(Integer.parseInt(rawPort));
                    } else {
                        Integer protocolPort = this.getProtocolConfig(specifiedProtocol).getPort();
                        if (null != protocolPort && protocolPort != -1) {
                            protocolConfig.setPort(protocolPort);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("5-16", "invalid specified " + specifiedProtocol + "  protocol", "", "Failed to find any valid protocol, will use random port to export metadata service.", e);
                }
            } else {
                protocolConfig.setPort(port);
            }
        }
        if (protocolConfig.getPort() == null) {
            protocolConfig.setPort(-1);
        }
        this.logger.info("Using " + specifiedProtocol + " protocol to export metadata service on port " + protocolConfig.getPort());
        return protocolConfig;
    }

    private Integer getSpecifiedPort() {
        String rawPort;
        Map<String, String> params;
        Integer port = this.getApplicationConfig().getMetadataServicePort();
        if (port == null && CollectionUtils.isNotEmptyMap(params = this.getApplicationConfig().getParameters()) && StringUtils.isNotEmpty(rawPort = this.getApplicationConfig().getParameters().get("metadata-service-port"))) {
            port = Integer.parseInt(rawPort);
        }
        return port;
    }

    private String getSpecifiedProtocol() {
        Map<String, String> params;
        String protocol = this.getApplicationConfig().getMetadataServiceProtocol();
        if (StringUtils.isEmpty(protocol) && CollectionUtils.isNotEmptyMap(params = this.getApplicationConfig().getParameters())) {
            protocol = this.getApplicationConfig().getParameters().get("metadata-service-protocol");
        }
        return StringUtils.isNotEmpty(protocol) ? protocol : "dubbo";
    }

    private ServiceConfig<MetadataService> buildServiceConfig() {
        ApplicationConfig applicationConfig = this.getApplicationConfig();
        ServiceConfig<MetadataService> serviceConfig = new ServiceConfig<MetadataService>();
        serviceConfig.setScopeModel(this.applicationModel.getInternalModule());
        serviceConfig.setApplication(applicationConfig);
        RegistryConfig registryConfig = new RegistryConfig("N/A");
        registryConfig.setId("internal-metadata-registry");
        serviceConfig.setRegistry(registryConfig);
        serviceConfig.setRegister(false);
        serviceConfig.setProtocol(this.generateMetadataProtocol());
        serviceConfig.setInterface(MetadataService.class);
        serviceConfig.setDelay(0);
        serviceConfig.setRef(this.metadataService);
        serviceConfig.setGroup(applicationConfig.getName());
        serviceConfig.setVersion("1.0.0");
        serviceConfig.setMethods(this.generateMethodConfig());
        serviceConfig.setConnections(1);
        serviceConfig.setExecutes(100);
        HashMap<String, String> threadParams = new HashMap<String, String>();
        threadParams.put("threadpool", "cached");
        threadParams.put("threads", "100");
        threadParams.put("corethreads", "2");
        serviceConfig.setParameters(threadParams);
        return serviceConfig;
    }

    private List<MethodConfig> generateMethodConfig() {
        MethodConfig methodConfig = new MethodConfig();
        methodConfig.setName("getAndListenInstanceMetadata");
        ArgumentConfig argumentConfig = new ArgumentConfig();
        argumentConfig.setIndex(1);
        argumentConfig.setCallback(true);
        methodConfig.setArguments(Collections.singletonList(argumentConfig));
        return Collections.singletonList(methodConfig);
    }

    public void setMetadataService(MetadataServiceDelegation metadataService) {
        this.metadataService = metadataService;
    }

    public List<URL> getExportedURLs() {
        return this.serviceConfig != null ? this.serviceConfig.getExportedUrls() : Collections.emptyList();
    }
}

