/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.stream;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

public class StreamUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger(StreamUtils.class);
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder().withoutPadding();

    public static String encodeBase64ASCII(byte[] in) {
        byte[] bytes = StreamUtils.encodeBase64(in);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    public static byte[] encodeBase64(byte[] in) {
        return BASE64_ENCODER.encode(in);
    }

    public static byte[] decodeASCIIByte(CharSequence value) {
        return BASE64_DECODER.decode(value.toString().getBytes(StandardCharsets.US_ASCII));
    }

    public static Map<String, Object> toAttachments(Map<String, Object> origin) {
        if (origin == null || origin.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> res = new HashMap<String, Object>(origin.size());
        origin.forEach((k, v) -> {
            if (Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)k)) {
                return;
            }
            if (TripleHeaderEnum.containsExcludeAttachments(k)) {
                return;
            }
            res.put((String)k, v);
        });
        return res;
    }

    public static void convertAttachment(DefaultHttp2Headers headers, Map<String, Object> attachments) {
        if (attachments == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : attachments.entrySet()) {
            String key = entry.getKey().toLowerCase(Locale.ROOT);
            if (Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)key) || TripleHeaderEnum.containsExcludeAttachments(key)) continue;
            Object v = entry.getValue();
            StreamUtils.convertSingleAttachment(headers, key, v);
        }
    }

    private static void convertSingleAttachment(DefaultHttp2Headers headers, String key, Object v) {
        try {
            if (v instanceof String || v instanceof Number || v instanceof Boolean) {
                String str = v.toString();
                headers.set((Object)key, (Object)str);
            } else if (v instanceof byte[]) {
                String str = StreamUtils.encodeBase64ASCII((byte[])v);
                headers.set((Object)(key + "-bin"), (Object)str);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Meet exception when convert single attachment key:" + key + " value=" + v, t);
        }
    }
}

