/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport;

import org.apache.dubbo.common.Parameters;
import org.apache.dubbo.common.Resetable;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Codec;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.transport.AbstractPeer;
import org.apache.dubbo.remoting.transport.codec.CodecAdapter;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public abstract class AbstractEndpoint
extends AbstractPeer
implements Resetable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEndpoint.class);
    private Codec2 codec;
    private int connectTimeout;

    public AbstractEndpoint(URL url, ChannelHandler handler) {
        super(url, handler);
        this.codec = AbstractEndpoint.getChannelCodec(url);
        this.connectTimeout = url.getPositiveParameter("connect.timeout", 3000);
    }

    protected static Codec2 getChannelCodec(URL url) {
        FrameworkModel frameworkModel;
        String codecName = url.getParameter("codec");
        if (StringUtils.isEmpty(codecName)) {
            codecName = url.getProtocol();
        }
        if ((frameworkModel = ScopeModelUtil.getFrameworkModel(url.getScopeModel())).getExtensionLoader(Codec2.class).hasExtension(codecName)) {
            return frameworkModel.getExtensionLoader(Codec2.class).getExtension(codecName);
        }
        if (frameworkModel.getExtensionLoader(Codec.class).hasExtension(codecName)) {
            return new CodecAdapter(frameworkModel.getExtensionLoader(Codec.class).getExtension(codecName));
        }
        return frameworkModel.getExtensionLoader(Codec2.class).getExtension("default");
    }

    @Override
    public void reset(URL url) {
        if (this.isClosed()) {
            throw new IllegalStateException("Failed to reset parameters " + url + ", cause: Channel closed. channel: " + this.getLocalAddress());
        }
        try {
            int t;
            if (url.hasParameter("connect.timeout") && (t = url.getParameter("connect.timeout", 0)) > 0) {
                this.connectTimeout = t;
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        try {
            if (url.hasParameter("codec")) {
                this.codec = AbstractEndpoint.getChannelCodec(url);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    @Deprecated
    public void reset(Parameters parameters) {
        this.reset(this.getUrl().addParameters(parameters.getParameters()));
    }

    protected Codec2 getCodec() {
        return this.codec;
    }

    protected int getConnectTimeout() {
        return this.connectTimeout;
    }
}

