/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.util;

import io.envoyproxy.envoy.api.v2.DeltaDiscoveryRequest;
import io.envoyproxy.envoy.api.v2.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.discovery.v3.DeltaDiscoveryResponse;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.registry.xds.XdsCertificateSigner;
import org.apache.dubbo.registry.xds.util.bootstrap.Bootstrapper;
import org.apache.dubbo.registry.xds.util.bootstrap.BootstrapperImpl;

public class XdsChannel {
    private static final Logger logger = LoggerFactory.getLogger(XdsChannel.class);
    private static final String USE_AGENT = "use-agent";
    private final ManagedChannel channel;

    protected XdsChannel(URL url) {
        ManagedChannel managedChannel = null;
        try {
            if (!url.getParameter(USE_AGENT, false)) {
                XdsCertificateSigner signer = url.getOrDefaultApplicationModel().getExtensionLoader(XdsCertificateSigner.class).getExtension(url.getParameter("signer", "istio"));
                XdsCertificateSigner.CertPair certPair = signer.GenerateCert(url);
                SslContext context = GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).keyManager((InputStream)new ByteArrayInputStream(certPair.getPublicKey().getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream(certPair.getPrivateKey().getBytes(StandardCharsets.UTF_8))).build();
                managedChannel = NettyChannelBuilder.forAddress((String)url.getHost(), (int)url.getPort()).sslContext(context).build();
            } else {
                BootstrapperImpl bootstrapper = new BootstrapperImpl();
                Bootstrapper.BootstrapInfo bootstrapInfo = bootstrapper.bootstrap();
                URLAddress address = URLAddress.parse(bootstrapInfo.servers().get(0).target(), null, false);
                EpollEventLoopGroup elg = new EpollEventLoopGroup();
                managedChannel = NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress("/" + address.getPath())).eventLoopGroup((EventLoopGroup)elg).channelType(EpollDomainSocketChannel.class).usePlaintext().build();
            }
        }
        catch (Exception e) {
            logger.error("Error occurred when creating gRPC channel to control panel.", e);
        }
        this.channel = managedChannel;
    }

    public StreamObserver<io.envoyproxy.envoy.service.discovery.v3.DeltaDiscoveryRequest> observeDeltaDiscoveryRequest(StreamObserver<DeltaDiscoveryResponse> observer) {
        return AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).deltaAggregatedResources(observer);
    }

    public StreamObserver<io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest> createDeltaDiscoveryRequest(StreamObserver<DiscoveryResponse> observer) {
        return AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).streamAggregatedResources(observer);
    }

    public StreamObserver<DeltaDiscoveryRequest> observeDeltaDiscoveryRequestV2(StreamObserver<io.envoyproxy.envoy.api.v2.DeltaDiscoveryResponse> observer) {
        return io.envoyproxy.envoy.service.discovery.v2.AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).deltaAggregatedResources(observer);
    }

    public StreamObserver<DiscoveryRequest> createDeltaDiscoveryRequestV2(StreamObserver<io.envoyproxy.envoy.api.v2.DiscoveryResponse> observer) {
        return io.envoyproxy.envoy.service.discovery.v2.AggregatedDiscoveryServiceGrpc.newStub((Channel)this.channel).streamAggregatedResources(observer);
    }

    public void destroy() {
        this.channel.shutdown();
    }
}

