/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.function.ThrowableConsumer;
import org.apache.dubbo.common.function.ThrowableFunction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.nacos.NacosNamingServiceWrapper;
import org.apache.dubbo.registry.nacos.util.NacosNamingServiceUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class NacosServiceDiscovery
extends AbstractServiceDiscovery {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String group;
    private final NacosNamingServiceWrapper namingService;
    private static final String NACOS_SD_USE_DEFAULT_GROUP_KEY = "dubbo.nacos-service-discovery.use-default-group";
    private final ConcurrentHashMap<String, NacosEventListener> eventListeners = new ConcurrentHashMap();

    public NacosServiceDiscovery(ApplicationModel applicationModel, URL registryURL) {
        super(applicationModel, registryURL);
        this.namingService = NacosNamingServiceUtils.createNamingService(registryURL);
        this.group = Boolean.parseBoolean(ConfigurationUtils.getProperty(applicationModel, NACOS_SD_USE_DEFAULT_GROUP_KEY, "false")) ? "DEFAULT_GROUP" : NacosNamingServiceUtils.getGroup(registryURL);
    }

    @Override
    public void doDestroy() throws Exception {
        this.namingService.shutdown();
        this.eventListeners.clear();
    }

    @Override
    public void doRegister(ServiceInstance serviceInstance) {
        ThrowableConsumer.execute(this.namingService, service -> {
            Instance instance = NacosNamingServiceUtils.toInstance(serviceInstance);
            service.registerInstance(instance.getServiceName(), this.group, instance);
        });
    }

    @Override
    public void doUnregister(ServiceInstance serviceInstance) throws RuntimeException {
        ThrowableConsumer.execute(this.namingService, service -> {
            Instance instance = NacosNamingServiceUtils.toInstance(serviceInstance);
            service.deregisterInstance(instance.getServiceName(), this.group, instance);
        });
    }

    @Override
    public Set<String> getServices() {
        return ThrowableFunction.execute(this.namingService, service -> {
            ListView<String> view = service.getServicesOfServer(0, Integer.MAX_VALUE, this.group);
            return new LinkedHashSet(view.getData());
        });
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        return ThrowableFunction.execute(this.namingService, service -> service.selectInstances(serviceName, this.group, true).stream().map(i -> NacosNamingServiceUtils.toServiceInstance(this.registryURL, i)).collect(Collectors.toList()));
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        if (!this.instanceListeners.add(listener)) {
            return;
        }
        for (String serviceName : listener.getServiceNames()) {
            NacosEventListener nacosEventListener = this.eventListeners.get(serviceName);
            if (nacosEventListener != null) {
                nacosEventListener.addListener(listener);
                continue;
            }
            try {
                nacosEventListener = new NacosEventListener();
                nacosEventListener.addListener(listener);
                this.namingService.subscribe(serviceName, this.group, nacosEventListener);
                this.eventListeners.put(serviceName, nacosEventListener);
            }
            catch (NacosException e) {
                this.logger.error("add nacos service instances changed listener fail ", e);
            }
        }
    }

    @Override
    public void removeServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws IllegalArgumentException {
        if (!this.instanceListeners.remove(listener)) {
            return;
        }
        for (String serviceName : listener.getServiceNames()) {
            NacosEventListener nacosEventListener = this.eventListeners.get(serviceName);
            if (nacosEventListener == null) continue;
            nacosEventListener.removeListener(listener);
            if (!nacosEventListener.isEmpty()) continue;
            this.eventListeners.remove(serviceName);
            try {
                this.namingService.unsubscribe(serviceName, this.group, nacosEventListener);
            }
            catch (NacosException e) {
                this.logger.error("remove nacos service instances changed listener fail ", e);
            }
        }
    }

    @Override
    public URL getUrl() {
        return this.registryURL;
    }

    private void handleEvent(NamingEvent event, ServiceInstancesChangedListener listener) {
        String serviceName = event.getServiceName();
        List<ServiceInstance> serviceInstances = event.getInstances().stream().map(i -> NacosNamingServiceUtils.toServiceInstance(this.registryURL, i)).collect(Collectors.toList());
        listener.onEvent(new ServiceInstancesChangedEvent(serviceName, serviceInstances));
    }

    public class NacosEventListener
    implements EventListener {
        private final Set<ServiceInstancesChangedListener> listeners = new ConcurrentHashSet<ServiceInstancesChangedListener>();

        public void onEvent(Event e) {
            if (e instanceof NamingEvent) {
                for (ServiceInstancesChangedListener listener : this.listeners) {
                    NamingEvent event = (NamingEvent)e;
                    NacosServiceDiscovery.this.handleEvent(event, listener);
                }
            }
        }

        public void addListener(ServiceInstancesChangedListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ServiceInstancesChangedListener listener) {
            this.listeners.remove(listener);
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }
    }
}

