/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceInstanceHostPortCustomizer
implements ServiceInstanceCustomizer {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ServiceInstanceHostPortCustomizer.class);

    @Override
    public void customize(ServiceInstance serviceInstance, ApplicationModel applicationModel) {
        if (serviceInstance.getPort() > 0) {
            return;
        }
        MetadataInfo metadataInfo = serviceInstance.getServiceMetadata();
        if (metadataInfo == null || CollectionUtils.isEmptyMap(metadataInfo.getExportedServiceURLs())) {
            return;
        }
        String host = null;
        int port = -1;
        HashSet urls = new HashSet();
        ConcurrentNavigableMap<String, SortedSet<URL>> exportedURLS = metadataInfo.getExportedServiceURLs();
        for (Map.Entry entry : exportedURLS.entrySet()) {
            if (entry.getValue() == null) continue;
            urls.addAll((Collection)entry.getValue());
        }
        if (CollectionUtils.isNotEmpty(urls)) {
            URL url;
            String preferredProtocol = applicationModel.getCurrentConfig().getProtocol();
            if (preferredProtocol != null) {
                for (URL exportedURL : urls) {
                    if (!preferredProtocol.equals(exportedURL.getProtocol())) continue;
                    host = exportedURL.getHost();
                    port = exportedURL.getPort();
                    break;
                }
                if (host == null || port == -1) {
                    logger.warn("4-2", "typo in preferred protocol", "", "Can't find an instance URL using the default preferredProtocol \"" + preferredProtocol + "\", falling back to the strategy that pick the first found protocol. Please try modifying the config of dubbo.application.protocol");
                    url = (URL)urls.iterator().next();
                    host = url.getHost();
                    port = url.getPort();
                }
            } else {
                url = (URL)urls.iterator().next();
                host = url.getHost();
                port = url.getPort();
            }
            if (serviceInstance instanceof DefaultServiceInstance) {
                DefaultServiceInstance instance = (DefaultServiceInstance)serviceInstance;
                instance.setHost(host);
                instance.setPort(port);
            }
        }
    }
}

