/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson2;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.fastjson2.Fastjson2CreatorManager;

public class FastJson2ObjectInput
implements ObjectInput {
    private final Fastjson2CreatorManager fastjson2CreatorManager;
    private volatile ClassLoader classLoader;
    private final InputStream is;

    public FastJson2ObjectInput(Fastjson2CreatorManager fastjson2CreatorManager, InputStream in) {
        this.fastjson2CreatorManager = fastjson2CreatorManager;
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.is = in;
        fastjson2CreatorManager.setCreator(this.classLoader);
    }

    @Override
    public boolean readBool() throws IOException {
        return this.readObject(Boolean.TYPE);
    }

    @Override
    public byte readByte() throws IOException {
        return this.readObject(Byte.TYPE);
    }

    @Override
    public short readShort() throws IOException {
        return this.readObject(Short.TYPE);
    }

    @Override
    public int readInt() throws IOException {
        return this.readObject(Integer.TYPE);
    }

    @Override
    public long readLong() throws IOException {
        return this.readObject(Long.TYPE);
    }

    @Override
    public float readFloat() throws IOException {
        return this.readObject(Float.TYPE).floatValue();
    }

    @Override
    public double readDouble() throws IOException {
        return this.readObject(Double.TYPE);
    }

    @Override
    public String readUTF() throws IOException {
        return this.readObject(String.class);
    }

    @Override
    public byte[] readBytes() throws IOException {
        int length = this.is.read();
        byte[] bytes = new byte[length];
        int read = this.is.read(bytes, 0, length);
        if (read != length) {
            throw new IllegalArgumentException("deserialize failed. expected read length: " + length + " but actual read: " + read);
        }
        return bytes;
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        return this.readObject(Object.class);
    }

    @Override
    public <T> T readObject(Class<T> cls) throws IOException {
        this.updateClassLoaderIfNeed();
        int length = this.readLength();
        byte[] bytes = new byte[length];
        int read = this.is.read(bytes, 0, length);
        if (read != length) {
            throw new IllegalArgumentException("deserialize failed. expected read length: " + length + " but actual read: " + read);
        }
        return (T)JSONB.parseObject((byte[])bytes, Object.class, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType, JSONReader.Feature.UseDefaultConstructorAsPossible, JSONReader.Feature.UseNativeObject, JSONReader.Feature.FieldBased});
    }

    @Override
    public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
        this.updateClassLoaderIfNeed();
        int length = this.readLength();
        byte[] bytes = new byte[length];
        int read = this.is.read(bytes, 0, length);
        if (read != length) {
            throw new IllegalArgumentException("deserialize failed. expected read length: " + length + " but actual read: " + read);
        }
        return (T)JSONB.parseObject((byte[])bytes, Object.class, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType, JSONReader.Feature.UseDefaultConstructorAsPossible, JSONReader.Feature.UseNativeObject, JSONReader.Feature.FieldBased});
    }

    private void updateClassLoaderIfNeed() {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentClassLoader != this.classLoader) {
            this.fastjson2CreatorManager.setCreator(currentClassLoader);
            this.classLoader = currentClassLoader;
        }
    }

    private int readLength() throws IOException {
        byte[] bytes = new byte[4];
        int read = this.is.read(bytes, 0, 4);
        if (read != 4) {
            throw new IllegalArgumentException("deserialize failed. expected read length: 4 but actual read: " + read);
        }
        int value = 0;
        for (byte b : bytes) {
            value = (value << 8) + (b & 0xFF);
        }
        return value;
    }
}

