/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationCache;
import org.apache.dubbo.common.config.configcenter.DynamicConfigurationFactory;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public final class ConfigurationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static final List<String> securityKey;

    private ConfigurationUtils() {
        throw new UnsupportedOperationException("No instance of 'ConfigurationUtils' for you! ");
    }

    public static Configuration getSystemConfiguration(ScopeModel scopeModel) {
        return ConfigurationUtils.getScopeModelOrDefaultApplicationModel(scopeModel).getModelEnvironment().getSystemConfiguration();
    }

    public static Configuration getEnvConfiguration(ScopeModel scopeModel) {
        return ConfigurationUtils.getScopeModelOrDefaultApplicationModel(scopeModel).getModelEnvironment().getEnvironmentConfiguration();
    }

    public static Configuration getGlobalConfiguration(ScopeModel scopeModel) {
        return ConfigurationUtils.getScopeModelOrDefaultApplicationModel(scopeModel).getModelEnvironment().getConfiguration();
    }

    public static Configuration getDynamicGlobalConfiguration(ScopeModel scopeModel) {
        return scopeModel.getModelEnvironment().getDynamicGlobalConfiguration();
    }

    public static int getServerShutdownTimeout(ScopeModel scopeModel) {
        int timeout = 10000;
        Configuration configuration = ConfigurationUtils.getGlobalConfiguration(scopeModel);
        String value = StringUtils.trim(configuration.getString("dubbo.service.shutdown.wait"));
        if (StringUtils.isNotEmpty(value)) {
            try {
                timeout = Integer.parseInt(value);
            }
            catch (Exception exception) {}
        } else {
            value = StringUtils.trim(configuration.getString("dubbo.service.shutdown.wait.seconds"));
            if (StringUtils.isNotEmpty(value)) {
                try {
                    timeout = Integer.parseInt(value) * 1000;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return timeout;
    }

    public static String getCachedDynamicProperty(ScopeModel realScopeModel, String key, String defaultValue) {
        ScopeModel scopeModel = ConfigurationUtils.getScopeModelOrDefaultApplicationModel(realScopeModel);
        ConfigurationCache configurationCache = scopeModel.getBeanFactory().getBean(ConfigurationCache.class);
        String value = configurationCache.computeIfAbsent(key, _k -> ConfigurationUtils.getDynamicProperty(scopeModel, _k, ""));
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    private static ScopeModel getScopeModelOrDefaultApplicationModel(ScopeModel realScopeModel) {
        if (realScopeModel == null) {
            return ApplicationModel.defaultModel();
        }
        return realScopeModel;
    }

    public static String getDynamicProperty(ScopeModel scopeModel, String property) {
        return ConfigurationUtils.getDynamicProperty(scopeModel, property, null);
    }

    public static String getDynamicProperty(ScopeModel scopeModel, String property, String defaultValue) {
        return StringUtils.trim(ConfigurationUtils.getDynamicGlobalConfiguration(scopeModel).getString(property, defaultValue));
    }

    public static String getProperty(ScopeModel scopeModel, String property) {
        return ConfigurationUtils.getProperty(scopeModel, property, null);
    }

    public static String getProperty(ScopeModel scopeModel, String property, String defaultValue) {
        return StringUtils.trim(ConfigurationUtils.getGlobalConfiguration(scopeModel).getString(property, defaultValue));
    }

    public static int get(ScopeModel scopeModel, String property, int defaultValue) {
        return ConfigurationUtils.getGlobalConfiguration(scopeModel).getInt(property, defaultValue);
    }

    public static Map<String, String> parseProperties(String content) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty(content)) {
            logger.warn("Config center was specified, but no config item found.");
        } else {
            Properties properties = new Properties();
            properties.load(new StringReader(content));
            properties.stringPropertyNames().forEach(k -> {
                boolean deny = false;
                for (String key : securityKey) {
                    if (!k.contains(key)) continue;
                    deny = true;
                    break;
                }
                if (!deny) {
                    map.put((String)k, properties.getProperty((String)k));
                }
            });
        }
        return map;
    }

    public static boolean isEmptyValue(Object value) {
        return value == null || value instanceof String && StringUtils.isBlank((String)value);
    }

    public static <V> Map<String, V> getSubProperties(Collection<Map<String, V>> configMaps, String prefix) {
        LinkedHashMap map = new LinkedHashMap();
        for (Map<String, V> configMap : configMaps) {
            ConfigurationUtils.getSubProperties(configMap, prefix, map);
        }
        return map;
    }

    public static <V> Map<String, V> getSubProperties(Map<String, V> configMap, String prefix) {
        return ConfigurationUtils.getSubProperties(configMap, prefix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <V> Map<String, V> getSubProperties(Map<String, V> configMap, String prefix, Map<String, V> resultMap) {
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        if (null == resultMap) {
            resultMap = new LinkedHashMap();
        }
        if (CollectionUtils.isNotEmptyMap(configMap)) {
            HashMap<String, V> copy;
            Map<String, V> map = configMap;
            synchronized (map) {
                copy = new HashMap<String, V>(configMap);
            }
            for (Map.Entry entry : copy.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (!StringUtils.startsWithIgnoreCase(key, prefix) || key.length() <= prefix.length() || ConfigurationUtils.isEmptyValue(val)) continue;
                String k = key.substring(prefix.length());
                String newK = StringUtils.convertToSplitName(k, "-");
                resultMap.putIfAbsent(newK, val);
                if (Objects.equals(k, newK)) continue;
                resultMap.putIfAbsent(k, val);
            }
        }
        return resultMap;
    }

    public static <V> boolean hasSubProperties(Collection<Map<String, V>> configMaps, String prefix) {
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        for (Map<String, V> configMap : configMaps) {
            if (!ConfigurationUtils.hasSubProperties(configMap, prefix)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> boolean hasSubProperties(Map<String, V> configMap, String prefix) {
        HashMap<String, V> copy;
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        Map<String, V> map = configMap;
        synchronized (map) {
            copy = new HashMap<String, V>(configMap);
        }
        for (Map.Entry entry : copy.entrySet()) {
            String key = (String)entry.getKey();
            if (!StringUtils.startsWithIgnoreCase(key, prefix) || key.length() <= prefix.length() || ConfigurationUtils.isEmptyValue(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> Set<String> getSubIds(Collection<Map<String, V>> configMaps, String prefix) {
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (Map<String, V> configMap : configMaps) {
            HashMap<String, V> copy;
            Map<String, V> map = configMap;
            synchronized (map) {
                copy = new HashMap<String, V>(configMap);
            }
            for (Map.Entry entry : copy.entrySet()) {
                String k;
                int endIndex;
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (!StringUtils.startsWithIgnoreCase(key, prefix) || key.length() <= prefix.length() || ConfigurationUtils.isEmptyValue(val) || (endIndex = (k = key.substring(prefix.length())).indexOf(".")) <= 0) continue;
                String id = k.substring(0, endIndex);
                ids.add(id);
            }
        }
        return ids;
    }

    public static DynamicConfigurationFactory getDynamicConfigurationFactory(ExtensionAccessor extensionAccessor, String name) {
        ExtensionLoader<DynamicConfigurationFactory> loader = extensionAccessor.getExtensionLoader(DynamicConfigurationFactory.class);
        return loader.getOrDefaultExtension(name);
    }

    @Deprecated
    public static Configuration getSystemConfiguration() {
        return ApplicationModel.defaultModel().getModelEnvironment().getSystemConfiguration();
    }

    @Deprecated
    public static Configuration getEnvConfiguration() {
        return ApplicationModel.defaultModel().getModelEnvironment().getEnvironmentConfiguration();
    }

    @Deprecated
    public static Configuration getGlobalConfiguration() {
        return ApplicationModel.defaultModel().getModelEnvironment().getConfiguration();
    }

    @Deprecated
    public static Configuration getDynamicGlobalConfiguration() {
        return ApplicationModel.defaultModel().getDefaultModule().getModelEnvironment().getDynamicGlobalConfiguration();
    }

    @Deprecated
    public static String getCachedDynamicProperty(String key, String defaultValue) {
        return ConfigurationUtils.getCachedDynamicProperty(ApplicationModel.defaultModel(), key, defaultValue);
    }

    @Deprecated
    public static String getDynamicProperty(String property) {
        return ConfigurationUtils.getDynamicProperty(ApplicationModel.defaultModel(), property);
    }

    @Deprecated
    public static String getDynamicProperty(String property, String defaultValue) {
        return ConfigurationUtils.getDynamicProperty(ApplicationModel.defaultModel(), property, defaultValue);
    }

    @Deprecated
    public static String getProperty(String property) {
        return ConfigurationUtils.getProperty(ApplicationModel.defaultModel(), property);
    }

    @Deprecated
    public static String getProperty(String property, String defaultValue) {
        return ConfigurationUtils.getProperty(ApplicationModel.defaultModel(), property, defaultValue);
    }

    @Deprecated
    public static int get(String property, int defaultValue) {
        return ConfigurationUtils.get(ApplicationModel.defaultModel(), property, defaultValue);
    }

    static {
        LinkedList<String> keys = new LinkedList<String>();
        keys.add("accesslog");
        keys.add("router");
        keys.add("rule");
        keys.add("runtime");
        keys.add("type");
        securityKey = Collections.unmodifiableList(keys);
    }
}

