/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.zookeeper.curator5;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.zookeeper.AbstractZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ChildListener;
import org.apache.dubbo.remoting.zookeeper.DataListener;
import org.apache.dubbo.remoting.zookeeper.EventType;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class Curator5ZookeeperClient
extends AbstractZookeeperClient<NodeCacheListenerImpl, CuratorWatcherImpl> {
    protected static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(Curator5ZookeeperClient.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final CuratorFramework client;
    private static Map<String, NodeCache> nodeCacheMap = new ConcurrentHashMap<String, NodeCache>();

    public Curator5ZookeeperClient(URL url) {
        super(url);
        try {
            int timeout = url.getParameter("timeout", this.DEFAULT_CONNECTION_TIMEOUT_MS);
            int sessionExpireMs = url.getParameter("session", this.DEFAULT_SESSION_TIMEOUT_MS);
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(url.getBackupAddress()).retryPolicy((RetryPolicy)new RetryNTimes(1, 1000)).connectionTimeoutMs(timeout).sessionTimeoutMs(sessionExpireMs);
            String userInformation = url.getUserInformation();
            if (userInformation != null && userInformation.length() > 0) {
                builder = builder.authorization("digest", userInformation.getBytes());
                builder.aclProvider(new ACLProvider(){

                    public List<ACL> getDefaultAcl() {
                        return ZooDefs.Ids.CREATOR_ALL_ACL;
                    }

                    public List<ACL> getAclForPath(String path) {
                        return ZooDefs.Ids.CREATOR_ALL_ACL;
                    }
                });
            }
            this.client = builder.build();
            this.client.getConnectionStateListenable().addListener((Object)new CuratorConnectionStateListener(url));
            this.client.start();
            boolean connected = this.client.blockUntilConnected(timeout, TimeUnit.MILLISECONDS);
            if (!connected) {
                IllegalStateException illegalStateException = new IllegalStateException("zookeeper not connected");
                logger.error("5-1", "Zookeeper server offline", "", "Failed to connect with zookeeper", illegalStateException);
                throw illegalStateException;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void createPersistent(String path) {
        try {
            this.client.create().forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            logger.warn("ZNode " + path + " already exists.", e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void createEphemeral(String path) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            logger.warn("ZNode " + path + " already exists, since we will only try to recreate a node on a session expiration, this duplication might be caused by a delete delay from the zk server, which means the old expired session may still holds this ZNode and the server just hasn't got time to do the deletion. In this case, we can just try to delete and create again.", e);
            this.deletePath(path);
            this.createEphemeral(path);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void createPersistent(String path, String data) {
        byte[] dataBytes = data.getBytes(CHARSET);
        try {
            this.client.create().forPath(path, dataBytes);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                this.client.setData().forPath(path, dataBytes);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e.getMessage(), e1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void createEphemeral(String path, String data) {
        byte[] dataBytes = data.getBytes(CHARSET);
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(path, dataBytes);
        }
        catch (KeeperException.NodeExistsException e) {
            logger.warn("ZNode " + path + " already exists, since we will only try to recreate a node on a session expiration, this duplication might be caused by a delete delay from the zk server, which means the old expired session may still holds this ZNode and the server just hasn't got time to do the deletion. In this case, we can just try to delete and create again.", e);
            this.deletePath(path);
            this.createEphemeral(path, data);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void update(String path, String data, int version) {
        byte[] dataBytes = data.getBytes(CHARSET);
        try {
            ((BackgroundPathAndBytesable)this.client.setData().withVersion(version)).forPath(path, dataBytes);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void createOrUpdatePersistent(String path, String data, int version) {
        try {
            if (this.checkExists(path)) {
                this.update(path, data, version);
            } else {
                this.createPersistent(path, data);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void createOrUpdateEphemeral(String path, String data, int version) {
        try {
            if (this.checkExists(path)) {
                this.update(path, data, version);
            } else {
                this.createEphemeral(path, data);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void deletePath(String path) {
        try {
            this.client.delete().deletingChildrenIfNeeded().forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getChildren(String path) {
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean checkExists(String path) {
        try {
            if (this.client.checkExists().forPath(path) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.client.getZookeeperClient().isConnected();
    }

    @Override
    public String doGetContent(String path) {
        try {
            byte[] dataBytes = (byte[])this.client.getData().forPath(path);
            return dataBytes == null || dataBytes.length == 0 ? null : new String(dataBytes, CHARSET);
        }
        catch (KeeperException.NoNodeException dataBytes) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public ConfigItem doGetConfigItem(String path) {
        String content;
        Stat stat;
        try {
            stat = new Stat();
            byte[] dataBytes = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(path);
            content = dataBytes == null || dataBytes.length == 0 ? null : new String(dataBytes, CHARSET);
        }
        catch (KeeperException.NoNodeException e) {
            return new ConfigItem();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return new ConfigItem(content, stat);
    }

    @Override
    public void doClose() {
        super.doClose();
        this.client.close();
    }

    @Override
    public CuratorWatcherImpl createTargetChildListener(String path, ChildListener listener) {
        return new CuratorWatcherImpl(this.client, listener, path);
    }

    @Override
    public List<String> addTargetChildListener(String path, CuratorWatcherImpl listener) {
        try {
            return (List)((BackgroundPathable)this.client.getChildren().usingWatcher((CuratorWatcher)listener)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected NodeCacheListenerImpl createTargetDataListener(String path, DataListener listener) {
        return new NodeCacheListenerImpl(this.client, listener, path);
    }

    @Override
    protected void addTargetDataListener(String path, NodeCacheListenerImpl nodeCacheListener) {
        this.addTargetDataListener(path, nodeCacheListener, (Executor)null);
    }

    @Override
    protected void addTargetDataListener(String path, NodeCacheListenerImpl nodeCacheListener, Executor executor) {
        try {
            NodeCache nodeCache = new NodeCache(this.client, path);
            if (nodeCacheMap.putIfAbsent(path, nodeCache) != null) {
                return;
            }
            if (executor == null) {
                nodeCache.getListenable().addListener((Object)nodeCacheListener);
            } else {
                nodeCache.getListenable().addListener((Object)nodeCacheListener, executor);
            }
            nodeCache.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Add nodeCache listener for path:" + path, e);
        }
    }

    @Override
    protected void removeTargetDataListener(String path, NodeCacheListenerImpl nodeCacheListener) {
        NodeCache nodeCache = nodeCacheMap.get(path);
        if (nodeCache != null) {
            nodeCache.getListenable().removeListener((Object)nodeCacheListener);
        }
        nodeCacheListener.dataListener = null;
    }

    @Override
    public void removeTargetChildListener(String path, CuratorWatcherImpl listener) {
        listener.unwatch();
    }

    CuratorFramework getClient() {
        return this.client;
    }

    private class CuratorConnectionStateListener
    implements ConnectionStateListener {
        private final long UNKNOWN_SESSION_ID = -1L;
        private long lastSessionId;
        private int timeout;
        private int sessionExpireMs;

        public CuratorConnectionStateListener(URL url) {
            this.timeout = url.getParameter("timeout", Curator5ZookeeperClient.this.DEFAULT_CONNECTION_TIMEOUT_MS);
            this.sessionExpireMs = url.getParameter("session", Curator5ZookeeperClient.this.DEFAULT_SESSION_TIMEOUT_MS);
        }

        public void stateChanged(CuratorFramework client, ConnectionState state) {
            long sessionId = -1L;
            try {
                sessionId = client.getZookeeperClient().getZooKeeper().getSessionId();
            }
            catch (Exception e) {
                logger.warn("Curator client state changed, but failed to get the related zk session instance.");
            }
            if (state == ConnectionState.LOST) {
                logger.warn("Curator zookeeper session " + Long.toHexString(this.lastSessionId) + " expired.");
                Curator5ZookeeperClient.this.stateChanged(0);
            } else if (state == ConnectionState.SUSPENDED) {
                logger.warn("Curator zookeeper connection of session " + Long.toHexString(sessionId) + " timed out. connection timeout value is " + this.timeout + ", session expire timeout value is " + this.sessionExpireMs);
                Curator5ZookeeperClient.this.stateChanged(3);
            } else if (state == ConnectionState.CONNECTED) {
                this.lastSessionId = sessionId;
                logger.info("Curator zookeeper client instance initiated successfully, session id is " + Long.toHexString(sessionId));
                Curator5ZookeeperClient.this.stateChanged(1);
            } else if (state == ConnectionState.RECONNECTED) {
                if (this.lastSessionId == sessionId && sessionId != -1L) {
                    logger.warn("Curator zookeeper connection recovered from connection lose, reuse the old session " + Long.toHexString(sessionId));
                    Curator5ZookeeperClient.this.stateChanged(2);
                } else {
                    logger.warn("New session created after old session lost, old session " + Long.toHexString(this.lastSessionId) + ", new session " + Long.toHexString(sessionId));
                    this.lastSessionId = sessionId;
                    Curator5ZookeeperClient.this.stateChanged(4);
                }
            }
        }
    }

    static class CuratorWatcherImpl
    implements CuratorWatcher {
        private CuratorFramework client;
        private volatile ChildListener childListener;
        private String path;

        public CuratorWatcherImpl(CuratorFramework client, ChildListener listener, String path) {
            this.client = client;
            this.childListener = listener;
            this.path = path;
        }

        protected CuratorWatcherImpl() {
        }

        public void unwatch() {
            this.childListener = null;
        }

        public void process(WatchedEvent event) throws Exception {
            if (event.getType() == Watcher.Event.EventType.None) {
                return;
            }
            if (this.childListener != null) {
                this.childListener.childChanged(this.path, (List)((BackgroundPathable)this.client.getChildren().usingWatcher((CuratorWatcher)this)).forPath(this.path));
            }
        }
    }

    static class NodeCacheListenerImpl
    implements NodeCacheListener {
        private CuratorFramework client;
        private volatile DataListener dataListener;
        private String path;

        protected NodeCacheListenerImpl() {
        }

        public NodeCacheListenerImpl(CuratorFramework client, DataListener dataListener, String path) {
            this.client = client;
            this.dataListener = dataListener;
            this.path = path;
        }

        public void nodeChanged() throws Exception {
            EventType eventType;
            ChildData childData = ((NodeCache)nodeCacheMap.get(this.path)).getCurrentData();
            String content = null;
            if (childData == null) {
                eventType = EventType.NodeDeleted;
            } else if (childData.getStat().getVersion() == 0) {
                content = new String(childData.getData(), CHARSET);
                eventType = EventType.NodeCreated;
            } else {
                content = new String(childData.getData(), CHARSET);
                eventType = EventType.NodeDataChanged;
            }
            this.dataListener.dataChanged(this.path, content, eventType);
        }
    }
}

