/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support.header;

import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.Parameters;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.GlobalResourceInitializer;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.Timeout;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.exchange.ExchangeChannel;
import org.apache.dubbo.remoting.exchange.ExchangeServer;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.support.header.AbstractTimerTask;
import org.apache.dubbo.remoting.exchange.support.header.CloseTimerTask;
import org.apache.dubbo.remoting.exchange.support.header.HeaderExchangeChannel;
import org.apache.dubbo.remoting.utils.UrlUtils;

public class HeaderExchangeServer
implements ExchangeServer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RemotingServer server;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    public static GlobalResourceInitializer<HashedWheelTimer> IDLE_CHECK_TIMER = new GlobalResourceInitializer<HashedWheelTimer>(() -> new HashedWheelTimer(new NamedThreadFactory("dubbo-server-idleCheck", true), 1L, TimeUnit.SECONDS, 128), HashedWheelTimer::stop);
    private Timeout closeTimer;

    public HeaderExchangeServer(RemotingServer server) {
        Assert.notNull((Object)server, "server == null");
        this.server = server;
        this.startIdleCheckTask(this.getUrl());
    }

    public RemotingServer getServer() {
        return this.server;
    }

    @Override
    public boolean isClosed() {
        return this.server.isClosed();
    }

    private boolean isRunning() {
        return this.getChannels().stream().anyMatch(Channel::isConnected);
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.doClose();
        this.server.close();
    }

    @Override
    public void close(int timeout) {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.startClose();
        if (timeout > 0) {
            long start = System.currentTimeMillis();
            if (this.getUrl().getParameter("channel.readonly.send", true)) {
                this.sendChannelReadOnlyEvent();
            }
            while (this.isRunning() && System.currentTimeMillis() - start < (long)timeout) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.logger.warn(e.getMessage(), e);
                }
            }
        }
        this.doClose();
        this.server.close(timeout);
    }

    @Override
    public void startClose() {
        this.server.startClose();
    }

    private void sendChannelReadOnlyEvent() {
        Request request = new Request();
        request.setEvent("R");
        request.setTwoWay(false);
        request.setVersion(Version.getProtocolVersion());
        Collection<Channel> channels = this.getChannels();
        for (Channel channel : channels) {
            try {
                if (!channel.isConnected()) continue;
                channel.send(request, this.getUrl().getParameter("channel.readonly.sent", true));
            }
            catch (RemotingException e) {
                if (this.closed.get() && e.getCause() instanceof ClosedChannelException) continue;
                this.logger.warn("send cannot write message error.", e);
            }
        }
    }

    private void doClose() {
        this.cancelCloseTask();
    }

    private void cancelCloseTask() {
        if (this.closeTimer != null) {
            this.closeTimer.cancel();
        }
    }

    @Override
    public Collection<ExchangeChannel> getExchangeChannels() {
        ArrayList<ExchangeChannel> exchangeChannels = new ArrayList<ExchangeChannel>();
        Collection<Channel> channels = this.server.getChannels();
        if (CollectionUtils.isNotEmpty(channels)) {
            for (Channel channel : channels) {
                exchangeChannels.add(HeaderExchangeChannel.getOrAddChannel(channel));
            }
        }
        return exchangeChannels;
    }

    @Override
    public ExchangeChannel getExchangeChannel(InetSocketAddress remoteAddress) {
        Channel channel = this.server.getChannel(remoteAddress);
        return HeaderExchangeChannel.getOrAddChannel(channel);
    }

    @Override
    public Collection<Channel> getChannels() {
        return this.getExchangeChannels();
    }

    @Override
    public Channel getChannel(InetSocketAddress remoteAddress) {
        return this.getExchangeChannel(remoteAddress);
    }

    @Override
    public boolean isBound() {
        return this.server.isBound();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.server.getLocalAddress();
    }

    @Override
    public URL getUrl() {
        return this.server.getUrl();
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return this.server.getChannelHandler();
    }

    @Override
    public void reset(URL url) {
        this.server.reset(url);
        try {
            int currHeartbeat = UrlUtils.getHeartbeat(this.getUrl());
            int currIdleTimeout = UrlUtils.getIdleTimeout(this.getUrl());
            int heartbeat = UrlUtils.getHeartbeat(url);
            int idleTimeout = UrlUtils.getIdleTimeout(url);
            if (currHeartbeat != heartbeat || currIdleTimeout != idleTimeout) {
                this.cancelCloseTask();
                this.startIdleCheckTask(url);
            }
        }
        catch (Throwable t) {
            this.logger.error(t.getMessage(), t);
        }
    }

    @Override
    @Deprecated
    public void reset(Parameters parameters) {
        this.reset(this.getUrl().addParameters(parameters.getParameters()));
    }

    @Override
    public void send(Object message) throws RemotingException {
        if (this.closed.get()) {
            throw new RemotingException(this.getLocalAddress(), null, "Failed to send message " + message + ", cause: The server " + this.getLocalAddress() + " is closed!");
        }
        this.server.send(message);
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {
        if (this.closed.get()) {
            throw new RemotingException(this.getLocalAddress(), null, "Failed to send message " + message + ", cause: The server " + this.getLocalAddress() + " is closed!");
        }
        this.server.send(message, sent);
    }

    private long calculateLeastDuration(int time) {
        if (time / 3 <= 0) {
            return 1000L;
        }
        return time / 3;
    }

    private void startIdleCheckTask(URL url) {
        if (!this.server.canHandleIdle()) {
            AbstractTimerTask.ChannelProvider cp = () -> Collections.unmodifiableCollection(this.getChannels());
            int idleTimeout = UrlUtils.getIdleTimeout(url);
            long idleTimeoutTick = this.calculateLeastDuration(idleTimeout);
            CloseTimerTask closeTimerTask = new CloseTimerTask(cp, idleTimeoutTick, idleTimeout);
            this.closeTimer = ((HashedWheelTimer)IDLE_CHECK_TIMER.get()).newTimeout(closeTimerTask, idleTimeoutTick, TimeUnit.MILLISECONDS);
        }
    }
}

