/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.status.reporter.FrameworkStatusReportService;
import org.apache.dubbo.registry.client.migration.MigrationClusterInvoker;
import org.apache.dubbo.registry.client.migration.ServiceDiscoveryMigrationInvoker;
import org.apache.dubbo.registry.client.migration.model.MigrationRule;
import org.apache.dubbo.registry.client.migration.model.MigrationStep;

public class MigrationRuleHandler<T> {
    public static final String DUBBO_SERVICEDISCOVERY_MIGRATION = "dubbo.application.migration.step";
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(MigrationRuleHandler.class);
    private MigrationClusterInvoker<T> migrationInvoker;
    private MigrationStep currentStep;
    private Float currentThreshold = Float.valueOf(0.0f);
    private URL consumerURL;

    public MigrationRuleHandler(MigrationClusterInvoker<T> invoker, URL url) {
        this.migrationInvoker = invoker;
        this.consumerURL = url;
    }

    public synchronized void doMigrate(MigrationRule rule) {
        if (this.migrationInvoker instanceof ServiceDiscoveryMigrationInvoker) {
            this.refreshInvoker(MigrationStep.FORCE_APPLICATION, Float.valueOf(1.0f), rule);
            return;
        }
        MigrationStep step = MigrationStep.APPLICATION_FIRST;
        float threshold = -1.0f;
        try {
            step = rule.getStep(this.consumerURL);
            threshold = rule.getThreshold(this.consumerURL);
        }
        catch (Exception e) {
            logger.error("Failed to get step and threshold info from rule: " + rule, e);
        }
        if (this.refreshInvoker(step, Float.valueOf(threshold), rule)) {
            this.setMigrationRule(rule);
        }
    }

    private boolean refreshInvoker(MigrationStep step, Float threshold, MigrationRule newRule) {
        if (step == null || threshold == null) {
            throw new IllegalStateException("Step or threshold of migration rule cannot be null");
        }
        MigrationStep originStep = this.currentStep;
        if (this.currentStep == null || this.currentStep != step || !this.currentThreshold.equals(threshold)) {
            boolean success = true;
            switch (step) {
                case APPLICATION_FIRST: {
                    this.migrationInvoker.migrateToApplicationFirstInvoker(newRule);
                    break;
                }
                case FORCE_APPLICATION: {
                    success = this.migrationInvoker.migrateToForceApplicationInvoker(newRule);
                    break;
                }
                default: {
                    success = this.migrationInvoker.migrateToForceInterfaceInvoker(newRule);
                }
            }
            if (success) {
                this.setCurrentStepAndThreshold(step, threshold);
                logger.info("Succeed Migrated to " + (Object)((Object)step) + " mode. Service Name: " + this.consumerURL.getDisplayServiceKey());
                this.report(step, originStep, "true");
            } else {
                logger.warn("Migrate to " + (Object)((Object)step) + " mode failed. Probably not satisfy the threshold you set " + threshold + ". Please try re-publish configuration if you still after check.");
                this.report(step, originStep, "false");
            }
            return success;
        }
        return true;
    }

    private void report(MigrationStep step, MigrationStep originStep, String success) {
        FrameworkStatusReportService reportService = this.consumerURL.getOrDefaultApplicationModel().getBeanFactory().getBean(FrameworkStatusReportService.class);
        if (reportService.hasReporter()) {
            reportService.reportMigrationStepStatus(reportService.createMigrationStepReport(this.consumerURL.getServiceInterface(), this.consumerURL.getVersion(), this.consumerURL.getGroup(), String.valueOf((Object)originStep), String.valueOf((Object)step), success));
        }
    }

    private void setMigrationRule(MigrationRule rule) {
        this.migrationInvoker.setMigrationRule(rule);
    }

    private Float getMigrationThreshold(MigrationRule rule, Float threshold) {
        Float configuredThreshold = Float.valueOf(rule.getThreshold(this.consumerURL));
        threshold = configuredThreshold == null ? threshold : configuredThreshold;
        return threshold;
    }

    private void setCurrentStepAndThreshold(MigrationStep currentStep, Float currentThreshold) {
        if (currentThreshold != null) {
            this.currentThreshold = currentThreshold;
        }
        if (currentStep != null) {
            this.currentStep = currentStep;
            this.migrationInvoker.setMigrationStep(currentStep);
        }
    }

    public MigrationStep getMigrationStep() {
        return this.currentStep;
    }
}

