/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.reference.ReferenceBeanSupport;
import org.apache.dubbo.config.spring.reference.ReferenceCreator;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReferenceBeanManager
implements ApplicationContextAware {
    public static final String BEAN_NAME = "dubboReferenceBeanManager";
    private final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, List<String>> referenceKeyMap = new ConcurrentHashMap<String, List<String>>();
    private Map<String, String> referenceAliasMap = new ConcurrentHashMap<String, String>();
    private Map<String, ReferenceBean> referenceBeanMap = new ConcurrentHashMap<String, ReferenceBean>();
    private Map<String, ReferenceConfig> referenceConfigMap = new ConcurrentHashMap<String, ReferenceConfig>();
    private ApplicationContext applicationContext;
    private volatile boolean initialized = false;
    private ModuleModel moduleModel;

    public void addReference(ReferenceBean referenceBean) throws Exception {
        ReferenceBean oldReferenceBean;
        String referenceKey;
        String referenceBeanName = referenceBean.getId();
        Assert.notEmptyString(referenceBeanName, "The id of ReferenceBean cannot be empty");
        if (!this.initialized) {
            this.logger.warn((Object)("Early initialize reference bean before DubboConfigBeanInitializer, the BeanPostProcessor has not been loaded at this time, which may cause abnormalities in some components (such as seata): " + referenceBeanName + " = " + ReferenceBeanSupport.generateReferenceKey(referenceBean, this.applicationContext)));
        }
        if (StringUtils.isEmpty(referenceKey = this.getReferenceKeyByBeanName(referenceBeanName))) {
            referenceKey = ReferenceBeanSupport.generateReferenceKey(referenceBean, this.applicationContext);
        }
        if ((oldReferenceBean = this.referenceBeanMap.get(referenceBeanName)) != null) {
            if (referenceBean != oldReferenceBean) {
                String oldReferenceKey = ReferenceBeanSupport.generateReferenceKey(oldReferenceBean, this.applicationContext);
                throw new IllegalStateException("Found duplicated ReferenceBean with id: " + referenceBeanName + ", old: " + oldReferenceKey + ", new: " + referenceKey);
            }
            return;
        }
        this.referenceBeanMap.put(referenceBeanName, referenceBean);
        this.registerReferenceKeyAndBeanName(referenceKey, referenceBeanName);
        if (this.initialized) {
            this.initReferenceBean(referenceBean);
        }
    }

    private String getReferenceKeyByBeanName(String referenceBeanName) {
        Set<Map.Entry<String, List<String>>> entries = this.referenceKeyMap.entrySet();
        for (Map.Entry<String, List<String>> entry : entries) {
            if (!entry.getValue().contains(referenceBeanName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void registerReferenceKeyAndBeanName(String referenceKey, String referenceBeanNameOrAlias) {
        List list = this.referenceKeyMap.computeIfAbsent(referenceKey, key -> new ArrayList());
        if (!list.contains(referenceBeanNameOrAlias)) {
            list.add(referenceBeanNameOrAlias);
            this.referenceAliasMap.put(referenceBeanNameOrAlias, (String)list.get(0));
        }
    }

    public ReferenceBean getById(String referenceBeanNameOrAlias) {
        String referenceBeanName = this.transformName(referenceBeanNameOrAlias);
        return this.referenceBeanMap.get(referenceBeanName);
    }

    private String transformName(String referenceBeanNameOrAlias) {
        return this.referenceAliasMap.getOrDefault(referenceBeanNameOrAlias, referenceBeanNameOrAlias);
    }

    public List<String> getBeanNamesByKey(String key) {
        return Collections.unmodifiableList(this.referenceKeyMap.getOrDefault(key, Collections.EMPTY_LIST));
    }

    public Collection<ReferenceBean> getReferences() {
        return new HashSet<ReferenceBean>(this.referenceBeanMap.values());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.moduleModel = DubboBeanUtils.getModuleModel((BeanFactory)applicationContext);
    }

    public void prepareReferenceBeans() throws Exception {
        this.initialized = true;
        for (ReferenceBean referenceBean : this.getReferences()) {
            this.initReferenceBean(referenceBean);
        }
    }

    private synchronized void initReferenceBean(ReferenceBean referenceBean) throws Exception {
        ReferenceConfig referenceConfig;
        if (referenceBean.getReferenceConfig() != null) {
            return;
        }
        String referenceKey = this.getReferenceKeyByBeanName(referenceBean.getId());
        if (StringUtils.isEmpty(referenceKey)) {
            referenceKey = ReferenceBeanSupport.generateReferenceKey(referenceBean, this.applicationContext);
        }
        if ((referenceConfig = this.referenceConfigMap.get(referenceKey)) == null) {
            Map<String, Object> referenceAttributes = ReferenceBeanSupport.getReferenceAttributes(referenceBean);
            referenceConfig = ReferenceCreator.create(referenceAttributes, this.applicationContext).defaultInterfaceClass(referenceBean.getObjectType()).build();
            if (referenceBean.getId() != null && !referenceBean.getId().contains("#")) {
                referenceConfig.setId(referenceBean.getId());
            }
            this.referenceConfigMap.put(referenceKey, referenceConfig);
            this.moduleModel.getConfigManager().addReference(referenceConfig);
        }
        referenceBean.setKeyAndReferenceConfig(referenceKey, referenceConfig);
    }
}

