/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ConfigInitializer;
import org.apache.dubbo.config.ConfigPostProcessor;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.cluster.support.ClusterUtils;
import org.apache.dubbo.rpc.model.AsyncMethodInfo;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.injvm.InjvmProtocol;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.stub.StubSuppliers;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class ReferenceConfig<T>
extends ReferenceConfigBase<T> {
    public static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ReferenceConfig.class);
    private Protocol protocolSPI;
    private ProxyFactory proxyFactory;
    private ConsumerModel consumerModel;
    private volatile transient T ref;
    private volatile transient Invoker<?> invoker;
    private volatile transient boolean initialized;
    private volatile transient boolean destroyed;
    private String services;

    public ReferenceConfig() {
    }

    public ReferenceConfig(ModuleModel moduleModel) {
        super(moduleModel);
    }

    public ReferenceConfig(Reference reference) {
        super(reference);
    }

    public ReferenceConfig(ModuleModel moduleModel, Reference reference) {
        super(moduleModel, reference);
    }

    @Override
    protected void postProcessAfterScopeModelChanged(ScopeModel oldScopeModel, ScopeModel newScopeModel) {
        super.postProcessAfterScopeModelChanged(oldScopeModel, newScopeModel);
        this.protocolSPI = this.getExtensionLoader(Protocol.class).getAdaptiveExtension();
        this.proxyFactory = this.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    }

    @Deprecated
    @Parameter(key="subscribed-services")
    public String getServices() {
        return this.services;
    }

    @Deprecated
    @Parameter(excluded=true)
    public Set<String> getSubscribedServices() {
        return StringUtils.splitToSet(this.getServices(), ',');
    }

    public void setServices(String services) {
        this.services = services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.destroyed) {
            throw new IllegalStateException("The invoker of ReferenceConfig(" + this.url + ") has already destroyed!");
        }
        if (this.ref == null) {
            this.getScopeModel().getDeployer().start();
            ReferenceConfig referenceConfig = this;
            synchronized (referenceConfig) {
                if (this.ref == null) {
                    this.init();
                }
            }
        }
        return this.ref;
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        try {
            if (this.invoker != null) {
                this.invoker.destroy();
            }
        }
        catch (Throwable t) {
            logger.warn("Unexpected error occurred when destroy invoker of ReferenceConfig(" + this.url + ").", t);
        }
        this.invoker = null;
        this.ref = null;
        if (this.consumerModel != null) {
            ModuleServiceRepository repository = this.getScopeModel().getServiceRepository();
            repository.unregisterConsumer(this.consumerModel);
        }
    }

    protected synchronized void init() {
        if (this.initialized && this.ref != null) {
            return;
        }
        try {
            ServiceDescriptor serviceDescriptor;
            if (!this.isRefreshed()) {
                this.refresh();
            }
            this.initServiceMetadata(this.consumer);
            this.serviceMetadata.setServiceType(this.getServiceInterfaceClass());
            this.serviceMetadata.setServiceKey(URL.buildKey(this.interfaceName, this.group, this.version));
            Map<String, String> referenceParameters = this.appendConfig();
            this.initServiceAppsMapping(referenceParameters);
            ModuleServiceRepository repository = this.getScopeModel().getServiceRepository();
            if ("nativestub".equals(this.getProxy())) {
                serviceDescriptor = StubSuppliers.getServiceDescriptor(this.interfaceName);
                repository.registerService(serviceDescriptor);
            } else {
                serviceDescriptor = repository.registerService(this.interfaceClass);
            }
            this.consumerModel = new ConsumerModel(this.serviceMetadata.getServiceKey(), this.proxy, serviceDescriptor, this.getScopeModel(), this.serviceMetadata, this.createAsyncMethodInfo(), this.interfaceClassLoader);
            this.consumerModel.setConfig(this);
            repository.registerConsumer(this.consumerModel);
            this.serviceMetadata.getAttachments().putAll(referenceParameters);
            this.ref = this.createProxy(referenceParameters);
            this.serviceMetadata.setTarget(this.ref);
            this.serviceMetadata.addAttribute("refClass", this.ref);
            this.consumerModel.setDestroyCaller(this.getDestroyRunner());
            this.consumerModel.setProxyObject(this.ref);
            this.consumerModel.initMethodModels();
            this.checkInvokerAvailable();
        }
        catch (Throwable t) {
            try {
                if (this.invoker != null) {
                    this.invoker.destroy();
                }
            }
            catch (Throwable destroy) {
                logger.warn("Unexpected error occurred when destroy invoker of ReferenceConfig(" + this.url + ").", destroy);
            }
            if (this.consumerModel != null) {
                ModuleServiceRepository repository = this.getScopeModel().getServiceRepository();
                repository.unregisterConsumer(this.consumerModel);
            }
            this.initialized = false;
            this.invoker = null;
            this.ref = null;
            this.consumerModel = null;
            this.serviceMetadata.setTarget(null);
            this.serviceMetadata.getAttributeMap().remove("refClass");
            if (t.getClass() == IllegalStateException.class && t.getMessage().contains("No provider available for the service")) {
                logger.error("2-2", "server crashed", "", "No provider available.", t);
            }
            throw t;
        }
        this.initialized = true;
    }

    private void initServiceAppsMapping(Map<String, String> referenceParameters) {
        ServiceNameMapping serviceNameMapping = ServiceNameMapping.getDefaultExtension(this.getScopeModel());
        ServiceConfigURL url = new ServiceConfigURL("injvm", "127.0.0.1", 0, this.interfaceName, referenceParameters);
        serviceNameMapping.initInterfaceAppMapping(url);
    }

    private Map<String, AsyncMethodInfo> createAsyncMethodInfo() {
        HashMap<String, AsyncMethodInfo> attributes = null;
        if (CollectionUtils.isNotEmpty(this.getMethods())) {
            attributes = new HashMap<String, AsyncMethodInfo>(16);
            for (MethodConfig methodConfig : this.getMethods()) {
                AsyncMethodInfo asyncMethodInfo = methodConfig.convertMethodConfig2AsyncInfo();
                if (asyncMethodInfo == null) continue;
                attributes.put(methodConfig.getName(), asyncMethodInfo);
            }
        }
        return attributes;
    }

    private Map<String, String> appendConfig() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("interface", this.interfaceName);
        map.put("side", "consumer");
        ReferenceConfigBase.appendRuntimeParameters(map);
        if (!ProtocolUtils.isGeneric(this.generic)) {
            String[] methods;
            String revision = Version.getVersion(this.interfaceClass, this.version);
            if (StringUtils.isNotEmpty(revision)) {
                map.put("revision", revision);
            }
            if ((methods = this.methods(this.interfaceClass)).length == 0) {
                logger.warn("No method found in service interface " + this.interfaceClass.getName());
                map.put("methods", "*");
            } else {
                map.put("methods", StringUtils.join(new HashSet<String>(Arrays.asList(methods)), ","));
            }
        }
        AbstractConfig.appendParameters(map, this.getApplication());
        AbstractConfig.appendParameters(map, this.getModule());
        AbstractConfig.appendParameters(map, this.consumer);
        AbstractConfig.appendParameters(map, this);
        this.appendMetricsCompatible(map);
        String hostToRegistry = ConfigUtils.getSystemProperty("DUBBO_IP_TO_REGISTRY");
        if (StringUtils.isEmpty(hostToRegistry)) {
            hostToRegistry = NetUtils.getLocalHost();
        } else if (NetUtils.isInvalidLocalHost(hostToRegistry)) {
            throw new IllegalArgumentException("Specified invalid registry ip from property:DUBBO_IP_TO_REGISTRY, value:" + hostToRegistry);
        }
        map.put("register.ip", hostToRegistry);
        if (CollectionUtils.isNotEmpty(this.getMethods())) {
            for (MethodConfig methodConfig : this.getMethods()) {
                String retryValue;
                AbstractConfig.appendParameters(map, methodConfig, methodConfig.getName());
                String retryKey = methodConfig.getName() + ".retry";
                if (!map.containsKey(retryKey) || !"false".equals(retryValue = (String)map.remove(retryKey))) continue;
                map.put(methodConfig.getName() + ".retries", "0");
            }
        }
        return map;
    }

    private T createProxy(Map<String, String> referenceParameters) {
        if (this.shouldJvmRefer(referenceParameters)) {
            this.createInvokerForLocal(referenceParameters);
        } else {
            this.urls.clear();
            this.meshModeHandleUrl(referenceParameters);
            if (StringUtils.isNotEmpty(this.url)) {
                this.parseUrl(referenceParameters);
            } else if (!"injvm".equalsIgnoreCase(this.getProtocol())) {
                this.aggregateUrlFromRegistry(referenceParameters);
            }
            this.createInvokerForRemote();
        }
        if (logger.isInfoEnabled()) {
            logger.info("Referred dubbo service: [" + referenceParameters.get("interface") + "]." + (Boolean.parseBoolean(referenceParameters.get("generic")) ? " it's GenericService reference" : " it's not GenericService reference"));
        }
        URL consumerUrl = new ServiceConfigURL("consumer", referenceParameters.get("register.ip"), 0, referenceParameters.get("interface"), referenceParameters);
        consumerUrl = consumerUrl.setScopeModel(this.getScopeModel());
        consumerUrl = consumerUrl.setServiceModel(this.consumerModel);
        MetadataUtils.publishServiceDefinition(consumerUrl, this.consumerModel.getServiceModel(), this.getApplicationModel());
        return (T)this.proxyFactory.getProxy(this.invoker, ProtocolUtils.isGeneric(this.generic));
    }

    private void meshModeHandleUrl(Map<String, String> referenceParameters) {
        String podNamespace;
        if (!this.checkMeshConfig(referenceParameters)) {
            return;
        }
        if (StringUtils.isNotEmpty(this.url)) {
            if (logger.isInfoEnabled()) {
                logger.info("The url already exists, mesh no longer processes url: " + this.url);
            }
            return;
        }
        if (StringUtils.isEmpty(System.getenv("POD_NAMESPACE"))) {
            if (logger.isWarnEnabled()) {
                logger.warn("Can not get env variable: POD_NAMESPACE, it may not be running in the K8S environment , finally use 'default' replace");
            }
            podNamespace = "default";
        } else {
            podNamespace = System.getenv("POD_NAMESPACE");
        }
        String providedBy = referenceParameters.get("provided-by");
        String clusterDomain = Optional.ofNullable(System.getenv("CLUSTER_DOMAIN")).orElse("cluster.local");
        Integer meshPort = Optional.ofNullable(this.getProviderPort()).orElse(CommonConstants.DEFAULT_MESH_PORT);
        meshPort = meshPort > -1 ? meshPort : CommonConstants.DEFAULT_MESH_PORT;
        this.url = "tri://" + providedBy + "." + podNamespace + ".svc." + clusterDomain + ":" + meshPort;
    }

    private boolean checkMeshConfig(Map<String, String> referenceParameters) {
        if (!"true".equals(referenceParameters.getOrDefault("mesh-enable", "false"))) {
            return false;
        }
        this.getScopeModel().getConfigManager().getProtocol("tri").orElseThrow(() -> new IllegalStateException("In mesh mode, a triple protocol must be specified"));
        String providedBy = referenceParameters.get("provided-by");
        if (StringUtils.isEmpty(providedBy)) {
            throw new IllegalStateException("In mesh mode, the providedBy of ReferenceConfig is must be set");
        }
        return true;
    }

    private void createInvokerForLocal(Map<String, String> referenceParameters) {
        URL url = new ServiceConfigURL("injvm", "127.0.0.1", 0, this.interfaceClass.getName(), referenceParameters);
        url = url.setScopeModel(this.getScopeModel());
        url = url.setServiceModel(this.consumerModel);
        Invoker withFilter = this.protocolSPI.refer(this.interfaceClass, url);
        ArrayList invokers = new ArrayList();
        invokers.add(withFilter);
        this.invoker = Cluster.getCluster(url.getScopeModel(), "failover").join(new StaticDirectory(url, invokers), true);
        if (logger.isInfoEnabled()) {
            logger.info("Using in jvm service " + this.interfaceClass.getName());
        }
    }

    private void parseUrl(Map<String, String> referenceParameters) {
        Object[] us = CommonConstants.SEMICOLON_SPLIT_PATTERN.split(this.url);
        if (ArrayUtils.isNotEmpty(us)) {
            for (Object u : us) {
                URL url = URL.valueOf((String)u);
                if (StringUtils.isEmpty(url.getPath())) {
                    url = url.setPath(this.interfaceName);
                }
                url = url.setScopeModel(this.getScopeModel());
                if (UrlUtils.isRegistry(url = url.setServiceModel(this.consumerModel))) {
                    this.urls.add(url.putAttribute("refer", referenceParameters));
                    continue;
                }
                URL peerUrl = this.getScopeModel().getApplicationModel().getBeanFactory().getBean(ClusterUtils.class).mergeUrl(url, referenceParameters);
                peerUrl = peerUrl.putAttribute("peer", true);
                this.urls.add(peerUrl);
            }
        }
    }

    private void aggregateUrlFromRegistry(Map<String, String> referenceParameters) {
        this.checkRegistry();
        List<URL> us = ConfigValidationUtils.loadRegistries(this, false);
        if (CollectionUtils.isNotEmpty(us)) {
            for (URL u : us) {
                URL monitorUrl = ConfigValidationUtils.loadMonitor(this, u);
                if (monitorUrl != null) {
                    u = u.putAttribute("monitor", monitorUrl);
                }
                u = u.setScopeModel(this.getScopeModel());
                u = u.setServiceModel(this.consumerModel);
                this.urls.add(u.putAttribute("refer", referenceParameters));
            }
        }
        if (this.urls.isEmpty()) {
            throw new IllegalStateException("No such any registry to reference " + this.interfaceName + " on the consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", please config <dubbo:registry address=\"...\" /> to your spring config.");
        }
    }

    private void createInvokerForRemote() {
        if (this.urls.size() == 1) {
            URL curUrl = (URL)this.urls.get(0);
            this.invoker = this.protocolSPI.refer(this.interfaceClass, curUrl);
            if (!UrlUtils.isRegistry(curUrl)) {
                ArrayList invokers = new ArrayList();
                invokers.add(this.invoker);
                this.invoker = Cluster.getCluster(this.scopeModel, "failover").join(new StaticDirectory(curUrl, invokers), true);
            }
        } else {
            ArrayList invokers = new ArrayList();
            URL registryUrl = null;
            for (URL url : this.urls) {
                invokers.add(this.protocolSPI.refer(this.interfaceClass, url));
                if (!UrlUtils.isRegistry(url)) continue;
                registryUrl = url;
            }
            if (registryUrl != null) {
                String cluster = registryUrl.getParameter("cluster", "zone-aware");
                this.invoker = Cluster.getCluster(registryUrl.getScopeModel(), cluster, false).join(new StaticDirectory(registryUrl, invokers), false);
            } else {
                if (CollectionUtils.isEmpty(invokers)) {
                    throw new IllegalArgumentException("invokers == null");
                }
                URL curUrl = ((Invoker)invokers.get(0)).getUrl();
                String cluster = curUrl.getParameter("cluster", "failover");
                this.invoker = Cluster.getCluster(this.scopeModel, cluster).join(new StaticDirectory(curUrl, invokers), true);
            }
        }
    }

    private void checkInvokerAvailable() throws IllegalStateException {
        if (this.shouldCheck() && !this.invoker.isAvailable()) {
            IllegalStateException illegalStateException = new IllegalStateException("Failed to check the status of the service " + this.interfaceName + ". No provider available for the service " + (this.group == null ? "" : this.group + "/") + this.interfaceName + (this.version == null ? "" : ":" + this.version) + " from the url " + this.invoker.getUrl() + " to the consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion());
            logger.error("2-2", "provider not started", "", "No provider available.", illegalStateException);
            throw illegalStateException;
        }
    }

    protected void checkAndUpdateSubConfigs() {
        if (StringUtils.isEmpty(this.interfaceName)) {
            throw new IllegalStateException("<dubbo:reference interface=\"\" /> interface not allow null!");
        }
        this.completeCompoundConfigs();
        List<ConfigInitializer> configInitializers = this.getExtensionLoader(ConfigInitializer.class).getActivateExtension(URL.valueOf("configInitializer://"), (String[])null);
        configInitializers.forEach(e -> e.initReferConfig(this));
        if (this.getGeneric() == null && this.getConsumer() != null) {
            this.setGeneric(this.getConsumer().getGeneric());
        }
        if (ProtocolUtils.isGeneric(this.generic)) {
            if (this.interfaceClass != null && !this.interfaceClass.equals(GenericService.class)) {
                logger.warn(String.format("Found conflicting attributes for interface type: [interfaceClass=%s] and [generic=%s], because the 'generic' attribute has higher priority than 'interfaceClass', so change 'interfaceClass' to '%s'. Note: it will make this reference bean as a candidate bean of type '%s' instead of '%s' when resolving dependency in Spring.", this.interfaceClass.getName(), this.generic, GenericService.class.getName(), GenericService.class.getName(), this.interfaceClass.getName()));
            }
            this.interfaceClass = GenericService.class;
        } else {
            try {
                if (this.getInterfaceClassLoader() != null && (this.interfaceClass == null || this.interfaceClass.getClassLoader() != this.getInterfaceClassLoader())) {
                    this.interfaceClass = Class.forName(this.interfaceName, true, this.getInterfaceClassLoader());
                } else if (this.interfaceClass == null) {
                    this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
                }
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalStateException(e2.getMessage(), e2);
            }
        }
        this.checkStubAndLocal(this.interfaceClass);
        ConfigValidationUtils.checkMock(this.interfaceClass, this);
        this.resolveFile();
        ConfigValidationUtils.validateReferenceConfig(this);
        this.postProcessConfig();
    }

    @Override
    protected void postProcessRefresh() {
        super.postProcessRefresh();
        this.checkAndUpdateSubConfigs();
    }

    protected void completeCompoundConfigs() {
        super.completeCompoundConfigs(this.consumer);
        if (this.consumer != null && StringUtils.isEmpty(this.registryIds)) {
            this.setRegistryIds(this.consumer.getRegistryIds());
        }
    }

    protected boolean shouldJvmRefer(Map<String, String> map) {
        ServiceConfigURL tmpUrl = new ServiceConfigURL("temp", "localhost", 0, map);
        boolean isJvmRefer = this.isInjvm() == null ? (StringUtils.isNotEmpty(this.url) ? false : InjvmProtocol.getInjvmProtocol(this.getScopeModel()).isInjvmRefer(tmpUrl)) : this.isInjvm();
        return isJvmRefer;
    }

    private void postProcessConfig() {
        List<ConfigPostProcessor> configPostProcessors = this.getExtensionLoader(ConfigPostProcessor.class).getActivateExtension(URL.valueOf("configPostProcessor://"), (String[])null);
        configPostProcessors.forEach(component -> component.postProcessReferConfig(this));
    }

    @Deprecated
    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    public Callable<Void> getDestroyRunner() {
        return () -> {
            this.destroy();
            return null;
        };
    }
}

